"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForDuplicateTitle = void 0;
var _i18n = require("@kbn/i18n");
var _maps_client = require("./maps_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rejectErrorMessage = _i18n.i18n.translate('xpack.maps.saveDuplicateRejectedDescription', {
  defaultMessage: 'Save with duplicate title confirmation was rejected'
});
const checkForDuplicateTitle = async ({
  id,
  title,
  lastSavedTitle,
  copyOnSave,
  isTitleDuplicateConfirmed,
  getDisplayName,
  onTitleDuplicate
}, {
  overlays
}) => {
  if (isTitleDuplicateConfirmed) {
    return true;
  }
  if (title === lastSavedTitle && !copyOnSave) {
    return true;
  }
  const {
    hits
  } = await _maps_client.mapsClient.search({
    text: `"${title}"`,
    limit: 10
  }, {
    onlyTitle: true
  });
  const existing = hits.find(obj => obj.attributes.title.toLowerCase() === title.toLowerCase());
  if (!existing || existing.id === id) {
    return true;
  }
  onTitleDuplicate();
  return Promise.reject(new Error(rejectErrorMessage));
};
exports.checkForDuplicateTitle = checkForDuplicateTitle;