"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawFilterControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _elasticsearch_util = require("../../../../../common/elasticsearch_util");
var _kibana_services = require("../../../../kibana_services");
var _draw_control = require("../draw_control");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DrawFilterControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_onDraw", async e => {
      if (!e.features.length || !this.props.drawState || !this.props.geoFieldNames.length) {
        return;
      }
      let filter;
      if (this.props.drawState.drawShape === _constants.DRAW_SHAPE.DISTANCE) {
        const circle = e.features[0];
        const distanceKm = _lodash.default.round(circle.properties.radiusKm, circle.properties.radiusKm > 10 ? 0 : 2);
        // Only include as much precision as needed for distance
        let precision = 2;
        if (distanceKm <= 1) {
          precision = 5;
        } else if (distanceKm <= 10) {
          precision = 4;
        } else if (distanceKm <= 100) {
          precision = 3;
        }
        filter = (0, _elasticsearch_util.createDistanceFilterWithMeta)({
          alias: this.props.drawState.filterLabel ? this.props.drawState.filterLabel : '',
          distanceKm,
          geoFieldNames: this.props.geoFieldNames,
          point: [_lodash.default.round(circle.properties.center[0], precision), _lodash.default.round(circle.properties.center[1], precision)]
        });
      } else {
        const geometry = e.features[0].geometry;
        // MapboxDraw returns coordinates with 12 decimals. Round to a more reasonable number
        (0, _elasticsearch_util.roundCoordinates)(geometry.coordinates);
        filter = (0, _elasticsearch_util.buildGeoShapeFilter)({
          geometry: this.props.drawState.drawShape === _constants.DRAW_SHAPE.BOUNDS ? (0, _elasticsearch_util.getBoundingBoxGeometry)(geometry) : geometry,
          geoFieldNames: this.props.geoFieldNames,
          geometryLabel: this.props.drawState.geometryLabel ? this.props.drawState.geometryLabel : '',
          relation: this.props.drawState.relation ? this.props.drawState.relation : _constants.ES_SPATIAL_RELATIONS.INTERSECTS
        });
      }
      try {
        await this.props.addFilters([filter], this.props.drawState.actionId);
      } catch (error) {
        (0, _kibana_services.getToasts)().addWarning(_i18n.i18n.translate('xpack.maps.drawFilterControl.unableToCreatFilter', {
          defaultMessage: `Unable to create filter, error: '{errorMsg}'.`,
          values: {
            errorMsg: error.message
          }
        }));
      } finally {
        this.props.disableDrawState();
      }
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_draw_control.DrawControl, {
      drawShape: this.props.filterModeActive && this.props.drawState ? this.props.drawState.drawShape : undefined,
      onDraw: this._onDraw,
      mbMap: this.props.mbMap,
      enable: this.props.filterModeActive
    });
  }
}
exports.DrawFilterControl = DrawFilterControl;