"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapSettingsPanel = MapSettingsPanel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _navigation_panel = require("./navigation_panel");
var _spatial_filters_panel = require("./spatial_filters_panel");
var _display_panel = require("./display_panel");
var _custom_icons_panel = require("./custom_icons_panel");
var _panel_strings = require("../panel_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MapSettingsPanel({
  cancelChanges,
  center,
  hasMapSettingsChanges,
  keepChanges,
  settings,
  customIcons,
  updateMapSetting,
  updateCustomIcons,
  deleteCustomIcon,
  zoom
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    className: "mapLayerPanel__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.mapSettingsPanel.title",
    defaultMessage: "Settings"
  })))), /*#__PURE__*/_react.default.createElement("div", {
    className: "mapLayerPanel__body"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "mapLayerPanel__bodyOverflow"
  }, /*#__PURE__*/_react.default.createElement(_custom_icons_panel.CustomIconsPanel, {
    customIcons: customIcons,
    updateCustomIcons: updateCustomIcons,
    deleteCustomIcon: deleteCustomIcon
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_display_panel.DisplayPanel, {
    settings: settings,
    updateMapSetting: updateMapSetting
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_navigation_panel.NavigationPanel, {
    center: center,
    settings: settings,
    updateMapSetting: updateMapSetting,
    zoom: zoom
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_spatial_filters_panel.SpatialFiltersPanel, {
    settings: settings,
    updateMapSetting: updateMapSetting
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "mapLayerPanel__footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: cancelChanges,
    flush: "left",
    "data-test-subj": "layerPanelCancelButton"
  }, hasMapSettingsChanges ? _panel_strings.panelStrings.discardChanges : _panel_strings.panelStrings.close)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !hasMapSettingsChanges,
    iconType: "check",
    onClick: keepChanges,
    fill: true,
    "data-test-subj": "mapSettingSubmitButton"
  }, _panel_strings.panelStrings.keepChanges)))));
}