"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterEditor = void 0;
var _reactRedux = require("react-redux");
var _filter_editor = require("./filter_editor");
var _map_selectors = require("../../../selectors/map_selectors");
var _actions = require("../../../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  var _getEditState;
  const layer = (0, _map_selectors.getSelectedLayer)(state);
  return {
    layer,
    isFeatureEditorOpenForLayer: ((_getEditState = (0, _map_selectors.getEditState)(state)) === null || _getEditState === void 0 ? void 0 : _getEditState.layerId) === layer.getId()
  };
}
function mapDispatchToProps(dispatch) {
  return {
    setLayerQuery: (layerId, query) => {
      dispatch((0, _actions.setLayerQuery)(layerId, query));
    },
    updateSourceProp: (id, propName, value) => dispatch((0, _actions.updateSourceProp)(id, propName, value))
  };
}
const connectedFilterEditor = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_filter_editor.FilterEditor);
exports.FilterEditor = connectedFilterEditor;