"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _layer_wizard_select = require("./layer_wizard_select");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutBody = props => {
  function renderContent() {
    if (!props.layerWizard || !props.currentStepId) {
      return /*#__PURE__*/_react.default.createElement(_layer_wizard_select.LayerWizardSelect, {
        onSelect: props.onWizardSelect
      });
    }
    const renderWizardArgs = {
      previewLayers: props.previewLayers,
      mapColors: props.mapColors,
      currentStepId: props.currentStepId,
      isOnFinalStep: props.isOnFinalStep,
      enableNextBtn: props.enableNextBtn,
      disableNextBtn: props.disableNextBtn,
      startStepLoading: props.startStepLoading,
      stopStepLoading: props.stopStepLoading,
      advanceToNextStep: props.advanceToNextStep
    };
    const backButton = props.showBackButton ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      flush: "left",
      onClick: props.onClear,
      iconType: "arrowLeft"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.addLayerPanel.changeDataSourceButtonLabel",
      defaultMessage: "Change layer"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })) : null;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, backButton, props.layerWizard.renderWizard(renderWizardArgs));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "mapLayerPanel__body",
    "data-test-subj": "layerAddForm"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "mapLayerPanel__bodyOverflow"
  }, renderContent()));
};
exports.FlyoutBody = FlyoutBody;