"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaskExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _mask_editor = require("./mask_editor");
var _es_agg_source = require("../../../classes/sources/es_agg_source");
var _mask = require("../../../classes/layers/vector_layer/mask");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MaskExpression extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  _getMaskExpressionValue() {
    return this.props.metric.mask === undefined ? '...' : (0, _mask.getMaskI18nValue)(this.props.metric.mask.operator, this.props.metric.mask.value);
  }
  _getAggLabel() {
    const aggDisplayName = (0, _es_agg_source.getAggDisplayName)(this.props.metric.type);
    if (this.props.metric.type === _constants.AGG_TYPE.COUNT || this.props.metric.field === undefined) {
      return aggDisplayName;
    }
    const targetField = this.props.fields.find(field => field.name === this.props.metric.field);
    const fieldDisplayName = targetField !== null && targetField !== void 0 && targetField.displayName ? targetField === null || targetField === void 0 ? void 0 : targetField.displayName : this.props.metric.field;
    return `${aggDisplayName} ${fieldDisplayName}`;
  }
  render() {
    // masks only supported for numerical metrics
    if (this.props.metric.type === _constants.AGG_TYPE.TERMS) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "mask",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        color: "subdued",
        description: (0, _mask.getMaskI18nDescription)({
          aggLabel: this._getAggLabel(),
          isJoin: this.props.isJoin
        }),
        value: this._getMaskExpressionValue(),
        onClick: this._togglePopover,
        uppercase: false
      }),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      panelPaddingSize: "s",
      anchorPosition: "downCenter",
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_mask_editor.MaskEditor, {
      metric: this.props.metric,
      onChange: this.props.onChange,
      onClose: this._closePopover
    }));
  }
}
exports.MaskExpression = MaskExpression;