"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeometryFilterForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-search-plugin/public");
var _constants = require("../../../../common/constants");
var _i18n_getters = require("../../../../common/i18n_getters");
var _action_select = require("../../action_select");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GeometryFilterForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      actionId: _public.ACTION_GLOBAL_APPLY_FILTER,
      geometryLabel: this.props.intitialGeometryLabel,
      relation: _constants.ES_SPATIAL_RELATIONS.INTERSECTS
    });
    (0, _defineProperty2.default)(this, "_onGeometryLabelChange", e => {
      this.setState({
        geometryLabel: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onRelationChange", e => {
      this.setState({
        relation: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onActionIdChange", value => {
      this.setState({
        actionId: value
      });
    });
    (0, _defineProperty2.default)(this, "_onSubmit", () => {
      this.props.onSubmit({
        actionId: this.state.actionId,
        geometryLabel: this.state.geometryLabel,
        relation: this.state.relation
      });
    });
  }
  _renderRelationInput() {
    const options = Object.values(_constants.ES_SPATIAL_RELATIONS).map(relation => {
      return {
        value: relation,
        text: (0, _i18n_getters.getEsSpatialRelationLabel)(relation)
      };
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.geometryFilterForm.relationLabel', {
        defaultMessage: 'Spatial relation'
      }),
      display: "rowCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      compressed: true,
      options: options,
      value: this.state.relation,
      onChange: this._onRelationChange
    }));
  }
  render() {
    let error;
    if (this.props.errorMsg) {
      error = /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, null, this.props.errorMsg);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      className: this.props.className
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.geometryFilterForm.geometryLabelLabel', {
        defaultMessage: 'Geometry label'
      }),
      display: "rowCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      compressed: true,
      value: this.state.geometryLabel,
      onChange: this._onGeometryLabelChange
    })), this._renderRelationInput(), /*#__PURE__*/_react.default.createElement(_action_select.ActionSelect, {
      getFilterActions: this.props.getFilterActions,
      getActionContext: this.props.getActionContext,
      value: this.state.actionId,
      onChange: this._onActionIdChange
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), error, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      onClick: this._onSubmit,
      isDisabled: !this.state.geometryLabel,
      isLoading: this.props.isLoading
    }, this.props.buttonLabel)));
  }
}
exports.GeometryFilterForm = GeometryFilterForm;