"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreakedLegend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _category = require("./category");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_VALUE = '';
class BreakedLegend extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      label: EMPTY_VALUE
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLabel();
  }
  componentDidUpdate() {
    this._loadLabel();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLabel() {
    const field = this.props.style.getField();
    if (!field) {
      return;
    }
    const label = await field.getLabel();
    if (this._isMounted && !_lodash.default.isEqual(this.state.label, label)) {
      this.setState({
        label
      });
    }
  }
  render() {
    if (this.state.label === EMPTY_VALUE) {
      return null;
    }
    const categories = this.props.breaks.map(({
      symbolId,
      svg,
      label,
      color
    }, index) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_category.Category, {
        styleName: this.props.style.getStyleName(),
        label: label,
        color: color,
        isLinesOnly: this.props.isLinesOnly,
        isPointsOnly: this.props.isPointsOnly,
        symbolId: symbolId,
        svg: svg
      }));
    });
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      title: this.props.style.getDisplayStyleName(),
      content: this.state.label
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: "eui-textTruncate",
      size: "xs",
      style: {
        maxWidth: '180px'
      }
    }, /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement("strong", null, this.state.label)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, categories));
  }
}
exports.BreakedLegend = BreakedLegend;