"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BuilderExceptionListItemComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _and_badge = require("./and_badge");
var _entry_delete_button = require("./entry_delete_button");
var _entry_renderer = require("./entry_renderer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyBeautifulLine = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &:after {
    background: ${({
  theme
}) => theme.eui.euiColorLightShade};
    content: '';
    width: 2px;
    height: 40px;
    margin: 0 15px;
  }
`;
const MyOverflowContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: hidden;
  width: 100%;
`;
const BuilderExceptionListItemComponent = /*#__PURE__*/_react.default.memo(({
  allowLargeValueLists,
  httpService,
  autocompleteService,
  exceptionItem,
  osTypes,
  exceptionItemIndex,
  indexPattern,
  isOnlyItem,
  listType,
  listTypeSpecificIndexPatternFilter,
  andLogicIncluded,
  onDeleteExceptionItem,
  onChangeExceptionItem,
  setErrorsExist,
  setWarningsExist,
  onlyShowListOperators = false,
  isDisabled = false,
  operatorsList,
  allowCustomOptions = false,
  getExtendedFields
}) => {
  const handleEntryChange = (0, _react.useCallback)((entry, entryIndex) => {
    const updatedEntries = [...exceptionItem.entries.slice(0, entryIndex), {
      ...entry
    }, ...exceptionItem.entries.slice(entryIndex + 1)];
    const updatedExceptionItem = {
      ...exceptionItem,
      entries: updatedEntries
    };
    onChangeExceptionItem(updatedExceptionItem, exceptionItemIndex);
  }, [onChangeExceptionItem, exceptionItem, exceptionItemIndex]);
  const handleDeleteEntry = (0, _react.useCallback)((entryIndex, parentIndex) => {
    const updatedExceptionItem = (0, _securitysolutionListUtils.getUpdatedEntriesOnDelete)(exceptionItem, entryIndex, parentIndex);
    onDeleteExceptionItem(updatedExceptionItem, exceptionItemIndex);
  }, [exceptionItem, onDeleteExceptionItem, exceptionItemIndex]);
  const entries = (0, _react.useMemo)(() => {
    const hasIndexPatternAndEntries = indexPattern != null && exceptionItem.entries.length > 0;
    return hasIndexPatternAndEntries ? (0, _securitysolutionListUtils.getFormattedBuilderEntries)(indexPattern, exceptionItem.entries, allowCustomOptions) : [];
  }, [exceptionItem.entries, indexPattern, allowCustomOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "exceptionEntriesContainer"
  }, andLogicIncluded && /*#__PURE__*/_react.default.createElement(_and_badge.BuilderAndBadgeComponent, {
    entriesLength: exceptionItem.entries.length,
    exceptionItemIndex: exceptionItemIndex
  }), /*#__PURE__*/_react.default.createElement(MyOverflowContainer, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, entries.map((item, index) => {
    var _id;
    const key = (_id = item.id) !== null && _id !== void 0 ? _id : `${index}`;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: key,
      grow: 1
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "row"
    }, item.nested === 'child' && /*#__PURE__*/_react.default.createElement(MyBeautifulLine, {
      grow: false
    }), /*#__PURE__*/_react.default.createElement(MyOverflowContainer, {
      grow: 1
    }, /*#__PURE__*/_react.default.createElement(_entry_renderer.BuilderEntryItem, {
      allowLargeValueLists: allowLargeValueLists,
      autocompleteService: autocompleteService,
      entry: item,
      httpService: httpService,
      indexPattern: indexPattern,
      listType: listType,
      listTypeSpecificIndexPatternFilter: listTypeSpecificIndexPatternFilter,
      onChange: handleEntryChange,
      onlyShowListOperators: onlyShowListOperators,
      setErrorsExist: setErrorsExist,
      setWarningsExist: setWarningsExist,
      osTypes: osTypes,
      isDisabled: isDisabled,
      showLabel: exceptionItemIndex === 0 && index === 0 && item.nested !== 'child',
      operatorsList: operatorsList,
      allowCustomOptions: allowCustomOptions,
      getExtendedFields: getExtendedFields
    })), /*#__PURE__*/_react.default.createElement(_entry_delete_button.BuilderEntryDeleteButtonComponent, {
      entries: exceptionItem.entries,
      entryIndex: item.entryIndex,
      exceptionItemIndex: exceptionItemIndex,
      isOnlyItem: isOnlyItem,
      nestedParentIndex: item.parent != null ? item.parent.parentIndex : null,
      onDelete: handleDeleteEntry
    })));
  })))));
});
exports.BuilderExceptionListItemComponent = BuilderExceptionListItemComponent;
BuilderExceptionListItemComponent.displayName = 'BuilderExceptionListItem';