"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lineCurveDefinitions = void 0;
var _public = require("@kbn/expression-xy-plugin/public");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lineCurveDefinitions = [{
  type: _public.XYCurveTypes.LINEAR,
  title: _i18n.i18n.translate('xpack.lens.lineCurve.straight', {
    defaultMessage: 'Straight'
  }),
  description: _i18n.i18n.translate('xpack.lens.lineCurveDescription.straight', {
    defaultMessage: 'Straight line between points'
  })
}, {
  type: _public.XYCurveTypes.CURVE_MONOTONE_X,
  title: _i18n.i18n.translate('xpack.lens.lineCurve.smooth', {
    defaultMessage: 'Smooth'
  }),
  description: _i18n.i18n.translate('xpack.lens.lineCurveDescription.smooth', {
    defaultMessage: 'Smoothed line between points'
  })
}, {
  type: _public.XYCurveTypes.CURVE_STEP_AFTER,
  title: _i18n.i18n.translate('xpack.lens.lineCurve.step', {
    defaultMessage: 'Step'
  }),
  description: _i18n.i18n.translate('xpack.lens.lineCurveDescription.step', {
    defaultMessage: 'Stepped line between points'
  })
}];
exports.lineCurveDefinitions = lineCurveDefinitions;