"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/event-annotation-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/visualization-ui-components/public");
var _moment = _interopRequireDefault(require("moment"));
var _public4 = require("@kbn/data-plugin/public");
var _constants = require("../../../../../common/constants");
var _utils = require("../../../../utils");
var _ = require("..");
var _visualization_helpers = require("../../visualization_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnnotationsPanel = props => {
  var _localLayer$annotatio;
  const {
    state,
    setState,
    layerId,
    accessor,
    frame
  } = props;
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _public3.useDebouncedValue)({
    value: state,
    onChange: setState
  });
  const index = localState.layers.findIndex(l => l.layerId === layerId);
  const localLayer = localState.layers.find(l => l.layerId === layerId);
  const currentAnnotation = (_localLayer$annotatio = localLayer.annotations) === null || _localLayer$annotatio === void 0 ? void 0 : _localLayer$annotatio.find(c => c.id === accessor);
  const setAnnotation = (0, _react.useCallback)(annotation => {
    if (annotation == null) {
      return;
    }
    const newConfigs = [...(localLayer.annotations || [])];
    const existingIndex = newConfigs.findIndex(c => c.id === accessor);
    if (existingIndex !== -1) {
      newConfigs[existingIndex] = annotation;
    } else {
      throw new Error('should never happen because annotation is created before config panel is opened');
    }
    setLocalState((0, _.updateLayer)(localState, {
      ...localLayer,
      annotations: newConfigs
    }, index));
  }, [accessor, index, localState, localLayer, setLocalState]);
  const [currentDataView, setCurrentDataView] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const updateDataView = async () => {
      let dataView;
      const availableIds = await props.dataViewsService.getIds();
      if (availableIds.includes(localLayer.indexPatternId)) {
        dataView = await props.dataViewsService.get(localLayer.indexPatternId);
      } else {
        dataView = await props.dataViewsService.create(frame.dataViews.indexPatterns[localLayer.indexPatternId].spec);
      }
      setCurrentDataView(dataView);
    };
    updateDataView();
  }, [frame.dataViews.indexPatterns, localLayer.indexPatternId, props.dataViewsService]);
  const queryInputServices = (0, _public2.useKibana)().services;
  if (!currentAnnotation) {
    throw new Error('Annotation not found... this should never happen!');
  }
  return currentDataView ? /*#__PURE__*/_react.default.createElement(_public.AnnotationEditorControls, {
    annotation: currentAnnotation,
    onAnnotationChange: newAnnotation => setAnnotation(newAnnotation),
    dataView: currentDataView,
    getDefaultRangeEnd: rangeStart => getEndTimestamp(props.datatableUtilities, rangeStart, frame, localState.layers.filter(_visualization_helpers.isDataLayer)),
    queryInputServices: queryInputServices,
    calendarClassName: _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
    appName: _constants.LENS_APP_NAME
  }) : null;
};
exports.AnnotationsPanel = AnnotationsPanel;
const getEndTimestamp = (datatableUtilities, startTime, {
  activeData,
  dateRange
}, dataLayers) => {
  var _datatableUtilities$g;
  const startTimeNumber = (0, _moment.default)(startTime).valueOf();
  const dateRangeFraction = ((0, _moment.default)(dateRange.toDate).valueOf() - (0, _moment.default)(dateRange.fromDate).valueOf()) * 0.1;
  const fallbackValue = (0, _moment.default)(startTimeNumber + dateRangeFraction).toISOString();
  const dataLayersId = dataLayers.map(({
    layerId
  }) => layerId);
  if (!dataLayersId.length || !activeData || Object.entries(activeData).filter(([key]) => dataLayersId.includes(key)).every(([, {
    rows
  }]) => !rows || !rows.length)) {
    return fallbackValue;
  }
  const xColumn = activeData === null || activeData === void 0 ? void 0 : activeData[dataLayersId[0]].columns.find(column => column.id === dataLayers[0].xAccessor);
  if (!xColumn) {
    return fallbackValue;
  }
  const dateInterval = (_datatableUtilities$g = datatableUtilities.getDateHistogramMeta(xColumn)) === null || _datatableUtilities$g === void 0 ? void 0 : _datatableUtilities$g.interval;
  if (!dateInterval) return fallbackValue;
  const intervalDuration = _public4.search.aggs.parseInterval(dateInterval);
  if (!intervalDuration) return fallbackValue;
  return (0, _moment.default)(startTimeNumber + 3 * intervalDuration.as('milliseconds')).toISOString();
};