"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getXyVisualization = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _charts = require("@elastic/charts");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
var _public = require("@kbn/event-annotation-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _public4 = require("@kbn/expression-xy-plugin/public");
var _lodash = require("lodash");
var _public5 = require("@kbn/visualization-ui-components/public");
var _id_generator = require("../../id_generator");
var _utils = require("../../utils");
var _xy_suggestions = require("./xy_suggestions");
var _xy_config_panel = require("./xy_config_panel");
var _dimension_editor = require("./xy_config_panel/dimension_editor");
var _layer_header = require("./xy_config_panel/layer_header");
var _types = require("./types");
var _state_helpers = require("./state_helpers");
var _to_expression = require("./to_expression");
var _color_assignment = require("./color_assignment");
var _reference_line_helpers = require("./reference_line_helpers");
var _helpers = require("./annotations/helpers");
var _visualization_helpers = require("./visualization_helpers");
var _axes_configuration = require("./axes_configuration");
var _reference_line_config_panel = require("./xy_config_panel/reference_line_config_panel");
var _annotations_config_panel = require("./xy_config_panel/annotations_config_panel");
var _drop_targets_utils = require("../../editor_frame_service/editor_frame/config_panel/buttons/drop_targets_utils");
var _actions = require("./annotations/actions");
var _add_layer = require("./add_layer");
var _layer_settings = require("./layer_settings");
var _ignore_global_filter = require("../../shared_components/ignore_global_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const XY_ID = 'lnsXY';
const getXyVisualization = ({
  core,
  storage,
  data,
  paletteService,
  fieldFormats,
  useLegacyTimeAxis,
  kibanaTheme,
  eventAnnotationService,
  unifiedSearch,
  dataViewsService,
  savedObjectsTagging
}) => ({
  id: XY_ID,
  visualizationTypes: _types.visualizationTypes,
  getVisualizationTypeId(state) {
    const type = (0, _visualization_helpers.getVisualizationType)(state);
    return type === 'mixed' ? type : type.id;
  },
  getLayerIds(state) {
    return (0, _visualization_helpers.getLayersByType)(state).map(l => l.layerId);
  },
  getRemoveOperation(state, layerId) {
    const dataLayers = (0, _visualization_helpers.getLayersByType)(state, _public4.LayerTypes.DATA).map(l => l.layerId);
    return dataLayers.includes(layerId) && dataLayers.length === 1 ? 'clear' : 'remove';
  },
  removeLayer(state, layerId) {
    return {
      ...state,
      layers: state.layers.filter(l => l.layerId !== layerId)
    };
  },
  cloneLayer(state, layerId, newLayerId, clonedIDsMap) {
    const toCopyLayer = state.layers.find(l => l.layerId === layerId);
    if (toCopyLayer) {
      if ((0, _visualization_helpers.isAnnotationsLayer)(toCopyLayer)) {
        toCopyLayer.annotations.forEach(i => clonedIDsMap.set(i.id, (0, _id_generator.generateId)()));
      }
      let newLayer = (0, _utils.renewIDs)(toCopyLayer, [...clonedIDsMap.keys()], id => clonedIDsMap.get(id));
      newLayer.layerId = newLayerId;
      if ((0, _visualization_helpers.isAnnotationsLayer)(newLayer) && (0, _visualization_helpers.isByReferenceAnnotationsLayer)(newLayer)) {
        const byValueVersion = {
          annotations: newLayer.annotations,
          ignoreGlobalFilters: newLayer.ignoreGlobalFilters,
          layerId: newLayer.layerId,
          layerType: newLayer.layerType,
          indexPatternId: newLayer.indexPatternId
        };
        newLayer = byValueVersion;
      }
      return {
        ...state,
        layers: [...state.layers, newLayer]
      };
    }
    return state;
  },
  appendLayer(state, layerId, layerType, indexPatternId, extraArg) {
    var _getDataLayers, _getDataLayers$;
    if (layerType === 'metricTrendline') {
      return state;
    }
    const firstUsedSeriesType = (_getDataLayers = (0, _visualization_helpers.getDataLayers)(state.layers)) === null || _getDataLayers === void 0 ? void 0 : (_getDataLayers$ = _getDataLayers[0]) === null || _getDataLayers$ === void 0 ? void 0 : _getDataLayers$.seriesType;
    return {
      ...state,
      layers: [...state.layers, (0, _visualization_helpers.newLayerState)({
        seriesType: firstUsedSeriesType || state.preferredSeriesType,
        layerId,
        layerType,
        indexPatternId,
        extraArg
      })]
    };
  },
  clearLayer(state, layerId, indexPatternId) {
    return {
      ...state,
      layers: state.layers.map(l => l.layerId !== layerId ? l : (0, _visualization_helpers.newLayerState)({
        seriesType: state.preferredSeriesType,
        layerId,
        indexPatternId
      }))
    };
  },
  getPersistableState(state) {
    return (0, _state_helpers.getPersistableState)(state);
  },
  getDescription: _visualization_helpers.getDescription,
  switchVisualizationType(seriesType, state) {
    return {
      ...state,
      preferredSeriesType: seriesType,
      layers: state.layers.map(layer => ({
        ...layer,
        seriesType: seriesType
      }))
    };
  },
  getSuggestions: _xy_suggestions.getSuggestions,
  triggers: [_public3.VIS_EVENT_TO_TRIGGER.filter, _public3.VIS_EVENT_TO_TRIGGER.brush],
  initialize(addNewLayer, state, _mainPalette, annotationGroups, references) {
    const finalState = state && (0, _state_helpers.isPersistedState)(state) ? (0, _state_helpers.injectReferences)(state, annotationGroups, references) : state;
    return finalState || {
      title: 'Empty XY chart',
      legend: {
        isVisible: true,
        position: _charts.Position.Right
      },
      valueLabels: 'hide',
      preferredSeriesType: _visualization_helpers.defaultSeriesType,
      layers: [{
        layerId: addNewLayer(),
        accessors: [],
        position: _charts.Position.Top,
        seriesType: _visualization_helpers.defaultSeriesType,
        showGridlines: false,
        layerType: _public4.LayerTypes.DATA
      }]
    };
  },
  getLayerType(layerId, state) {
    var _state$layers$find;
    return state === null || state === void 0 ? void 0 : (_state$layers$find = state.layers.find(({
      layerId: id
    }) => id === layerId)) === null || _state$layers$find === void 0 ? void 0 : _state$layers$find.layerType;
  },
  getSupportedLayers(state, frame) {
    return [_visualization_helpers.supportedDataLayer, (0, _helpers.getAnnotationsSupportedLayer)(state, frame), (0, _reference_line_helpers.getReferenceSupportedLayer)(state, frame)];
  },
  getSupportedActionsForLayer(layerId, state, setState, registerLibraryAnnotationGroup, isSaveable) {
    const layerIndex = state.layers.findIndex(l => l.layerId === layerId);
    const layer = state.layers[layerIndex];
    const actions = [];
    if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
      actions.push(...(0, _actions.createAnnotationActions)({
        state,
        layer,
        setState,
        registerLibraryAnnotationGroup,
        core,
        isSaveable,
        eventAnnotationService,
        savedObjectsTagging,
        dataViews: data.dataViews,
        kibanaTheme
      }));
    }
    return actions;
  },
  getCustomRemoveLayerText(layerId, state) {
    const layerIndex = state.layers.findIndex(l => l.layerId === layerId);
    const layer = state.layers[layerIndex];
    if (layer && (0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer)) {
      return {
        title: `Delete "${layer.__lastSaved.title}"`
      };
    }
  },
  hasLayerSettings({
    state,
    layerId: currentLayerId
  }) {
    var _state$layers;
    const layer = (_state$layers = state.layers) === null || _state$layers === void 0 ? void 0 : _state$layers.find(({
      layerId
    }) => layerId === currentLayerId);
    return {
      data: Boolean(layer && (0, _visualization_helpers.isAnnotationsLayer)(layer)),
      appearance: false
    };
  },
  renderLayerSettings(domElement, props) {
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: kibanaTheme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_layer_settings.LayerSettings, props))), domElement);
  },
  onIndexPatternChange(state, indexPatternId, layerId) {
    const layerIndex = state.layers.findIndex(l => l.layerId === layerId);
    const layer = state.layers[layerIndex];
    if (!layer || !(0, _visualization_helpers.isAnnotationsLayer)(layer)) {
      return state;
    }
    const newLayers = [...state.layers];
    newLayers[layerIndex] = {
      ...layer,
      indexPatternId
    };
    return {
      ...state,
      layers: newLayers
    };
  },
  getConfiguration({
    state,
    frame,
    layerId
  }) {
    var _dataLayer$palette, _dataLayer$palette2;
    const layer = state.layers.find(l => l.layerId === layerId);
    if (!layer) {
      return {
        groups: []
      };
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
      return (0, _helpers.getAnnotationsConfiguration)({
        state,
        frame,
        layer
      });
    }
    const sortedAccessors = (0, _to_expression.getSortedAccessors)(frame.datasourceLayers[layer.layerId], layer);
    if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
      return (0, _reference_line_helpers.getReferenceConfiguration)({
        state,
        frame,
        layer,
        sortedAccessors
      });
    }
    const mappedAccessors = getMappedAccessors({
      state,
      frame,
      layer,
      fieldFormats,
      paletteService,
      accessors: sortedAccessors
    });
    const dataLayer = layer;
    const dataLayers = (0, _visualization_helpers.getDataLayers)(state.layers);
    const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
    const {
      left,
      right
    } = (0, _axes_configuration.groupAxesByType)([layer], frame.activeData);
    // Check locally if it has one accessor OR one accessor per axis
    const layerHasOnlyOneAccessor = Boolean(dataLayer.accessors.length < 2 || left.length && left.length < 2 || right.length && right.length < 2);
    // Check also for multiple layers that can stack for percentage charts
    // Make sure that if multiple dimensions are defined for a single dataLayer, they should belong to the same axis
    const hasOnlyOneAccessor = layerHasOnlyOneAccessor && dataLayers.filter(
    // check that the other layers are compatible with this one
    l => {
      if ((0, _visualization_helpers.isDataLayer)(l) && l.seriesType === dataLayer.seriesType && Boolean(l.xAccessor) === Boolean(dataLayer.xAccessor) && Boolean(l.splitAccessor) === Boolean(dataLayer.splitAccessor)) {
        const {
          left: localLeft,
          right: localRight
        } = (0, _axes_configuration.groupAxesByType)([l], frame.activeData);
        // return true only if matching axis are found
        return l.accessors.length && (Boolean(localLeft.length) === Boolean(left.length) || Boolean(localRight.length) === Boolean(right.length));
      }
      return false;
    }).length < 2;
    return {
      groups: [{
        groupId: 'x',
        groupLabel: (0, _visualization_helpers.getAxisName)('x', {
          isHorizontal
        }),
        accessors: dataLayer.xAccessor ? [{
          columnId: dataLayer.xAccessor
        }] : [],
        filterOperations: _visualization_helpers.isBucketed,
        supportsMoreColumns: !dataLayer.xAccessor,
        dataTestSubj: 'lnsXY_xDimensionPanel'
      }, {
        groupId: 'y',
        groupLabel: (0, _visualization_helpers.getAxisName)('y', {
          isHorizontal
        }),
        accessors: mappedAccessors,
        filterOperations: _visualization_helpers.isNumericDynamicMetric,
        isMetricDimension: true,
        supportsMoreColumns: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsXY_yDimensionPanel',
        enableDimensionEditor: true
      }, {
        groupId: 'breakdown',
        groupLabel: _i18n.i18n.translate('xpack.lens.xyChart.splitSeries', {
          defaultMessage: 'Breakdown'
        }),
        accessors: dataLayer.splitAccessor ? [{
          columnId: dataLayer.splitAccessor,
          triggerIconType: dataLayer.collapseFn ? 'aggregate' : 'colorBy',
          palette: dataLayer.collapseFn ? undefined : paletteService.get(((_dataLayer$palette = dataLayer.palette) === null || _dataLayer$palette === void 0 ? void 0 : _dataLayer$palette.name) || 'default').getCategoricalColors(10, (_dataLayer$palette2 = dataLayer.palette) === null || _dataLayer$palette2 === void 0 ? void 0 : _dataLayer$palette2.params)
        }] : [],
        filterOperations: _visualization_helpers.isBucketed,
        supportsMoreColumns: !dataLayer.splitAccessor,
        dataTestSubj: 'lnsXY_splitDimensionPanel',
        requiredMinDimensionCount: dataLayer.seriesType.includes('percentage') && hasOnlyOneAccessor ? 1 : 0,
        enableDimensionEditor: true
      }]
    };
  },
  getMainPalette: state => {
    var _getFirstDataLayer;
    if (!state || state.layers.length === 0) return;
    return (_getFirstDataLayer = (0, _visualization_helpers.getFirstDataLayer)(state.layers)) === null || _getFirstDataLayer === void 0 ? void 0 : _getFirstDataLayer.palette;
  },
  getDropProps(dropProps) {
    if (!dropProps.source) {
      return;
    }
    const srcDataView = dropProps.source.indexPatternId;
    const targetDataView = dropProps.target.indexPatternId;
    if (!targetDataView || srcDataView !== targetDataView) {
      return;
    }
    if ((0, _utils.isDraggedDataViewField)(dropProps.source)) {
      if (dropProps.source.field.type === 'document') {
        return;
      }
      return dropProps.target.isNewColumn ? {
        dropTypes: ['field_add']
      } : {
        dropTypes: ['field_replace']
      };
    }
    if ((0, _utils.isOperationFromTheSameGroup)(dropProps.source, dropProps.target)) {
      return dropProps.target.isNewColumn ? {
        dropTypes: ['duplicate_compatible']
      } : {
        dropTypes: ['reorder']
      };
    }
    if ((0, _utils.isOperationFromCompatibleGroup)(dropProps.source, dropProps.target)) {
      return {
        dropTypes: dropProps.target.isNewColumn ? ['move_compatible', 'duplicate_compatible'] : ['replace_compatible', 'replace_duplicate_compatible', 'swap_compatible']
      };
    }
  },
  onDrop(props) {
    const targetLayer = props.prevState.layers.find(l => l.layerId === props.target.layerId);
    if (!targetLayer) {
      throw new Error('target layer should exist');
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(targetLayer)) {
      return (_helpers.onAnnotationDrop === null || _helpers.onAnnotationDrop === void 0 ? void 0 : (0, _helpers.onAnnotationDrop)(props)) || props.prevState;
    }
    return (0, _drop_targets_utils.onDropForVisualization)(props, this);
  },
  setDimension(props) {
    const {
      prevState,
      layerId,
      columnId,
      groupId
    } = props;
    const foundLayer = prevState.layers.find(l => l.layerId === layerId);
    if (!foundLayer) {
      return prevState;
    }
    if ((0, _visualization_helpers.isReferenceLayer)(foundLayer)) {
      return (0, _reference_line_helpers.setReferenceDimension)(props);
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(foundLayer)) {
      return (0, _helpers.setAnnotationsDimension)(props);
    }
    const newLayer = Object.assign({}, foundLayer);
    if (groupId === 'x') {
      newLayer.xAccessor = columnId;
    }
    if (groupId === 'y') {
      newLayer.accessors = [...newLayer.accessors.filter(a => a !== columnId), columnId];
    }
    if (groupId === 'breakdown') {
      newLayer.splitAccessor = columnId;
    }
    return {
      ...prevState,
      layers: prevState.layers.map(l => l.layerId === layerId ? newLayer : l)
    };
  },
  removeDimension({
    prevState,
    layerId,
    columnId,
    frame
  }) {
    const foundLayer = prevState.layers.find(l => l.layerId === layerId);
    if (!foundLayer) {
      return prevState;
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(foundLayer)) {
      const newLayer = {
        ...foundLayer,
        annotations: foundLayer.annotations.filter(({
          id
        }) => id !== columnId)
      };
      const newLayers = prevState.layers.map(l => l.layerId === layerId ? newLayer : l);
      return {
        ...prevState,
        layers: newLayers
      };
    }
    const newLayer = {
      ...foundLayer
    };
    if ((0, _visualization_helpers.isDataLayer)(newLayer)) {
      if (newLayer.xAccessor === columnId) {
        delete newLayer.xAccessor;
      } else if (newLayer.splitAccessor === columnId) {
        delete newLayer.splitAccessor;
        // as the palette is associated with the break down by dimension, remove it together with the dimension
        delete newLayer.palette;
      }
    }
    if (newLayer.accessors.includes(columnId)) {
      newLayer.accessors = newLayer.accessors.filter(a => a !== columnId);
    }
    if ('yConfig' in newLayer) {
      var _newLayer$yConfig;
      newLayer.yConfig = (_newLayer$yConfig = newLayer.yConfig) === null || _newLayer$yConfig === void 0 ? void 0 : _newLayer$yConfig.filter(({
        forAccessor
      }) => forAccessor !== columnId);
    }
    let newLayers = prevState.layers.map(l => l.layerId === layerId ? newLayer : l);
    // check if there's any reference layer and pull it off if all data layers have no dimensions set
    // check for data layers if they all still have xAccessors
    const groupsAvailable = (0, _reference_line_helpers.getGroupsAvailableInData)((0, _visualization_helpers.getDataLayers)(prevState.layers), frame.datasourceLayers, frame.activeData);
    if (Object.keys(groupsAvailable).every(id => !groupsAvailable[id])) {
      newLayers = newLayers.filter(layer => (0, _visualization_helpers.isDataLayer)(layer) || 'accessors' in layer && layer.accessors.length);
    }
    return {
      ...prevState,
      layers: newLayers
    };
  },
  renderLayerPanel(domElement, props) {
    const {
      onChangeIndexPattern,
      ...otherProps
    } = props;
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: kibanaTheme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: {
        appName: 'lens',
        storage,
        uiSettings: core.uiSettings,
        data,
        fieldFormats,
        savedObjects: core.savedObjects,
        docLinks: core.docLinks,
        http: core.http,
        unifiedSearch
      }
    }, /*#__PURE__*/_react.default.createElement(_layer_header.LayerHeaderContent, (0, _extends2.default)({}, otherProps, {
      onChangeIndexPattern: indexPatternId => {
        // TODO: should it trigger an action as in the datasource?
        onChangeIndexPattern(indexPatternId);
      }
    }))))), domElement);
  },
  renderLayerHeader(domElement, props) {
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: kibanaTheme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_layer_header.LayerHeader, props))), domElement);
  },
  renderToolbar(domElement, props) {
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: kibanaTheme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_xy_config_panel.XyToolbar, (0, _extends2.default)({}, props, {
      useLegacyTimeAxis: useLegacyTimeAxis
    })))), domElement);
  },
  renderDimensionEditor(domElement, props) {
    const allProps = {
      ...props,
      datatableUtilities: data.datatableUtilities,
      formatFactory: fieldFormats.deserialize,
      paletteService
    };
    const layer = props.state.layers.find(l => l.layerId === props.layerId);
    const dimensionEditor = (0, _visualization_helpers.isReferenceLayer)(layer) ? /*#__PURE__*/_react.default.createElement(_reference_line_config_panel.ReferenceLinePanel, allProps) : (0, _visualization_helpers.isAnnotationsLayer)(layer) ? /*#__PURE__*/_react.default.createElement(_annotations_config_panel.AnnotationsPanel, (0, _extends2.default)({}, allProps, {
      dataViewsService: dataViewsService
    })) : /*#__PURE__*/_react.default.createElement(_dimension_editor.DataDimensionEditor, allProps);
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: kibanaTheme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: {
        appName: 'lens',
        storage,
        uiSettings: core.uiSettings,
        data,
        fieldFormats,
        savedObjects: core.savedObjects,
        docLinks: core.docLinks,
        http: core.http,
        unifiedSearch
      }
    }, dimensionEditor))), domElement);
  },
  renderDimensionEditorDataExtra(domElement, props) {
    const allProps = {
      ...props,
      datatableUtilities: data.datatableUtilities,
      formatFactory: fieldFormats.deserialize,
      paletteService
    };
    const layer = props.state.layers.find(l => l.layerId === props.layerId);
    if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
      return;
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
      return;
    }
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: kibanaTheme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: {
        appName: 'lens',
        storage,
        uiSettings: core.uiSettings,
        data,
        fieldFormats,
        savedObjects: core.savedObjects,
        docLinks: core.docLinks,
        http: core.http,
        unifiedSearch
      }
    }, /*#__PURE__*/_react.default.createElement(_dimension_editor.DataDimensionEditorDataSectionExtra, allProps)))), domElement);
  },
  getAddLayerButtonComponent: props => {
    return /*#__PURE__*/_react.default.createElement(_add_layer.AddLayerButton, (0, _extends2.default)({}, props, {
      eventAnnotationService: eventAnnotationService,
      addLayer: async (type, loadedGroupInfo) => {
        if (type === _public4.LayerTypes.ANNOTATIONS && loadedGroupInfo) {
          var _loadedGroupInfo$data;
          await props.ensureIndexPattern((_loadedGroupInfo$data = loadedGroupInfo.dataViewSpec) !== null && _loadedGroupInfo$data !== void 0 ? _loadedGroupInfo$data : loadedGroupInfo.indexPatternId);
          props.registerLibraryAnnotationGroup({
            id: loadedGroupInfo.annotationGroupId,
            group: loadedGroupInfo
          });
        }
        props.addLayer(type, loadedGroupInfo, !!loadedGroupInfo);
      }
    }));
  },
  toExpression: (state, layers, attributes, datasourceExpressionsByLayers = {}) => (0, _to_expression.toExpression)(state, layers, paletteService, datasourceExpressionsByLayers, eventAnnotationService),
  toPreviewExpression: (state, layers, datasourceExpressionsByLayers = {}) => (0, _to_expression.toPreviewExpression)(state, layers, paletteService, datasourceExpressionsByLayers, eventAnnotationService),
  getUserMessages(state, {
    frame
  }) {
    const {
      datasourceLayers,
      dataViews,
      activeData
    } = frame;
    const annotationLayers = (0, _visualization_helpers.getAnnotationsLayers)(state.layers);
    const errors = [];
    const hasDateHistogram = (0, _helpers.isDateHistogram)((0, _visualization_helpers.getDataLayers)(state.layers), frame);
    annotationLayers.forEach(layer => {
      layer.annotations.forEach(annotation => {
        if (!hasDateHistogram) {
          errors.push({
            severity: 'error',
            fixableInEditor: true,
            displayLocations: [{
              id: 'dimensionButton',
              dimensionId: annotation.id
            }],
            shortMessage: _i18n.i18n.translate('xpack.lens.xyChart.addAnnotationsLayerLabelDisabledHelp', {
              defaultMessage: 'Annotations require a time based chart to work. Add a date histogram.'
            }),
            longMessage: ''
          });
        }
        const errorMessages = (0, _state_helpers.getAnnotationLayerErrors)(layer, annotation.id, dataViews);
        errors.push(...errorMessages.map(errorMessage => {
          const message = {
            severity: 'error',
            fixableInEditor: true,
            displayLocations: [{
              id: 'visualization'
            }, {
              id: 'dimensionButton',
              dimensionId: annotation.id
            }],
            shortMessage: errorMessage,
            longMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.lens.xyChart.annotationError",
              defaultMessage: "Annotation {annotationName} has an error: {errorMessage}",
              values: {
                annotationName: annotation.label,
                errorMessage
              }
            })
          };
          return message;
        }));
      });
    });

    // Data error handling below here
    const hasNoAccessors = ({
      accessors
    }) => accessors == null || accessors.length === 0;
    const dataLayers = (0, _visualization_helpers.getDataLayers)(state.layers);
    const hasNoSplitAccessor = ({
      splitAccessor,
      seriesType
    }) => seriesType.includes('percentage') && splitAccessor == null;

    // check if the layers in the state are compatible with this type of chart
    if (state && state.layers.length > 1) {
      // Order is important here: Y Axis is fundamental to exist to make it valid
      const checks = [['Y', hasNoAccessors], ['Break down', hasNoSplitAccessor]];

      // filter out those layers with no accessors at all
      const filteredLayers = dataLayers.filter(({
        accessors,
        xAccessor,
        splitAccessor,
        layerType
      }) => accessors.length > 0 || xAccessor != null || splitAccessor != null);
      for (const [dimension, criteria] of checks) {
        const result = (0, _visualization_helpers.validateLayersForDimension)(dimension, filteredLayers, criteria);
        if (!result.valid) {
          errors.push({
            severity: 'error',
            fixableInEditor: true,
            displayLocations: [{
              id: 'visualization'
            }],
            shortMessage: result.payload.shortMessage,
            longMessage: result.payload.longMessage
          });
        }
      }
    }
    // temporary fix for #87068
    errors.push(...(0, _visualization_helpers.checkXAccessorCompatibility)(state, datasourceLayers).map(({
      shortMessage,
      longMessage
    }) => ({
      severity: 'error',
      fixableInEditor: true,
      displayLocations: [{
        id: 'visualization'
      }],
      shortMessage,
      longMessage
    })));
    for (const layer of (0, _visualization_helpers.getDataLayers)(state.layers)) {
      const datasourceAPI = datasourceLayers[layer.layerId];
      if (datasourceAPI) {
        for (const accessor of layer.accessors) {
          const operation = datasourceAPI.getOperationForColumnId(accessor);
          if (operation && operation.dataType !== 'number') {
            errors.push({
              severity: 'error',
              fixableInEditor: true,
              displayLocations: [{
                id: 'visualization'
              }],
              shortMessage: _i18n.i18n.translate('xpack.lens.xyVisualization.dataTypeFailureYShort', {
                defaultMessage: `Wrong data type for {axis}.`,
                values: {
                  axis: (0, _visualization_helpers.getAxisName)('y', {
                    isHorizontal: (0, _state_helpers.isHorizontalChart)(state.layers)
                  })
                }
              }),
              longMessage: _i18n.i18n.translate('xpack.lens.xyVisualization.dataTypeFailureYLong', {
                defaultMessage: `The dimension {label} provided for the {axis} has the wrong data type. Expected number but have {dataType}`,
                values: {
                  label: operation.label,
                  dataType: operation.dataType,
                  axis: (0, _visualization_helpers.getAxisName)('y', {
                    isHorizontal: (0, _state_helpers.isHorizontalChart)(state.layers)
                  })
                }
              })
            });
          }
        }
      }
    }
    const warnings = [];
    if ((state === null || state === void 0 ? void 0 : state.layers.length) > 0 && activeData) {
      const filteredLayers = [...(0, _visualization_helpers.getDataLayers)(state.layers), ...(0, _visualization_helpers.getReferenceLayers)(state.layers)].filter(({
        accessors
      }) => accessors.length > 0);
      const accessorsWithArrayValues = [];
      for (const layer of filteredLayers) {
        const {
          layerId,
          accessors
        } = layer;
        const rows = (activeData === null || activeData === void 0 ? void 0 : activeData[layerId]) && activeData[layerId].rows;
        if (!rows) {
          break;
        }
        const columnToLabel = (0, _state_helpers.getColumnToLabelMap)(layer, datasourceLayers[layerId]);
        for (const accessor of accessors) {
          const hasArrayValues = rows.some(row => Array.isArray(row[accessor]));
          if (hasArrayValues) {
            accessorsWithArrayValues.push(columnToLabel[accessor]);
          }
        }
      }
      accessorsWithArrayValues.forEach(label => warnings.push({
        severity: 'warning',
        fixableInEditor: true,
        displayLocations: [{
          id: 'toolbar'
        }],
        shortMessage: '',
        longMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          key: label,
          id: "xpack.lens.xyVisualization.arrayValues",
          defaultMessage: "{label} contains array values. Your visualization may not render as expected.",
          values: {
            label: /*#__PURE__*/_react.default.createElement("strong", null, label)
          }
        })
      }));
    }
    const info = getNotifiableFeatures(state, frame, paletteService, fieldFormats);
    return errors.concat(warnings, info);
  },
  getUniqueLabels(state) {
    return (0, _helpers.getUniqueLabels)(state.layers);
  },
  getUsedDataView(state, layerId) {
    var _getAnnotationsLayers;
    return (_getAnnotationsLayers = (0, _visualization_helpers.getAnnotationsLayers)(state.layers).find(l => l.layerId === layerId)) === null || _getAnnotationsLayers === void 0 ? void 0 : _getAnnotationsLayers.indexPatternId;
  },
  getUsedDataViews(state) {
    var _state$layers$filter$;
    return (_state$layers$filter$ = state === null || state === void 0 ? void 0 : state.layers.filter(_visualization_helpers.isAnnotationsLayer).map(({
      indexPatternId
    }) => indexPatternId)) !== null && _state$layers$filter$ !== void 0 ? _state$layers$filter$ : [];
  },
  renderDimensionTrigger({
    columnId,
    label
  }) {
    if (label) {
      return /*#__PURE__*/_react.default.createElement(_public5.DimensionTrigger, {
        id: columnId,
        label: label || _helpers.defaultAnnotationLabel
      });
    }
    return null;
  },
  getSuggestionFromConvertToLensContext({
    suggestions,
    context
  }) {
    const allSuggestions = suggestions;
    const suggestion = {
      ...allSuggestions[0],
      datasourceState: {
        ...allSuggestions[0].datasourceState,
        layers: allSuggestions.reduce((acc, s) => {
          var _s$datasourceState;
          return {
            ...acc,
            ...((_s$datasourceState = s.datasourceState) === null || _s$datasourceState === void 0 ? void 0 : _s$datasourceState.layers)
          };
        }, {})
      },
      visualizationState: {
        ...allSuggestions[0].visualizationState,
        ...context.configuration
      }
    };
    return suggestion;
  },
  isEqual(state1, references1, state2, references2, annotationGroups) {
    const injected1 = (0, _state_helpers.injectReferences)(state1, annotationGroups, references1);
    const injected2 = (0, _state_helpers.injectReferences)(state2, annotationGroups, references2);
    return (0, _lodash.isEqual)(injected1, injected2);
  },
  getVisualizationInfo(state, frame) {
    return getVisualizationInfo(state, frame, paletteService, fieldFormats);
  }
});
exports.getXyVisualization = getXyVisualization;
const getMappedAccessors = ({
  accessors,
  frame,
  fieldFormats,
  paletteService,
  state,
  layer
}) => {
  let mappedAccessors = accessors.map(accessor => ({
    columnId: accessor
  }));
  if (frame.activeData) {
    const colorAssignments = (0, _color_assignment.getColorAssignments)((0, _visualization_helpers.getDataLayers)(state.layers), {
      tables: frame.activeData
    }, fieldFormats.deserialize);
    mappedAccessors = (0, _color_assignment.getAccessorColorConfigs)(colorAssignments, frame, {
      ...layer,
      accessors: accessors.filter(sorted => layer.accessors.includes(sorted))
    }, paletteService);
  }
  return mappedAccessors;
};
function getVisualizationInfo(state, frame, paletteService, fieldFormats) {
  const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
  const visualizationLayersInfo = state.layers.map(layer => {
    const palette = [];
    const dimensions = [];
    let chartType;
    let icon;
    let label;
    if ((0, _visualization_helpers.isDataLayer)(layer)) {
      chartType = layer.seriesType;
      const layerVisType = _types.visualizationTypes.find(visType => visType.id === chartType);
      icon = layerVisType === null || layerVisType === void 0 ? void 0 : layerVisType.icon;
      label = (layerVisType === null || layerVisType === void 0 ? void 0 : layerVisType.fullLabel) || (layerVisType === null || layerVisType === void 0 ? void 0 : layerVisType.label);
      if (layer.xAccessor) {
        dimensions.push({
          name: (0, _visualization_helpers.getAxisName)('x', {
            isHorizontal
          }),
          id: layer.xAccessor,
          dimensionType: 'x'
        });
      }
      if (layer.accessors && layer.accessors.length) {
        layer.accessors.forEach(accessor => {
          dimensions.push({
            name: (0, _visualization_helpers.getAxisName)('y', {
              isHorizontal
            }),
            id: accessor,
            dimensionType: 'y'
          });
        });
        if (frame !== null && frame !== void 0 && frame.datasourceLayers && frame.activeData) {
          const sortedAccessors = (0, _to_expression.getSortedAccessors)(frame.datasourceLayers[layer.layerId], layer);
          const mappedAccessors = getMappedAccessors({
            state,
            frame: frame,
            layer,
            fieldFormats,
            paletteService,
            accessors: sortedAccessors
          });
          palette.push(...mappedAccessors.flatMap(({
            color
          }) => color));
        }
      }
      if (layer.splitAccessor) {
        dimensions.push({
          name: _i18n.i18n.translate('xpack.lens.xyChart.splitSeries', {
            defaultMessage: 'Breakdown'
          }),
          dimensionType: 'breakdown',
          id: layer.splitAccessor
        });
        if (!layer.collapseFn) {
          var _layer$palette, _layer$palette2;
          palette.push(...paletteService.get(((_layer$palette = layer.palette) === null || _layer$palette === void 0 ? void 0 : _layer$palette.name) || 'default').getCategoricalColors(10, (_layer$palette2 = layer.palette) === null || _layer$palette2 === void 0 ? void 0 : _layer$palette2.params));
        }
      }
    }
    if ((0, _visualization_helpers.isReferenceLayer)(layer) && layer.accessors && layer.accessors.length) {
      layer.accessors.forEach(accessor => {
        dimensions.push({
          name: _i18n.i18n.translate('xpack.lens.xyChart.layerReferenceLine', {
            defaultMessage: 'Reference line'
          }),
          dimensionType: 'reference_line',
          id: accessor
        });
      });
      label = _i18n.i18n.translate('xpack.lens.xyChart.layerReferenceLineLabel', {
        defaultMessage: 'Reference lines'
      });
      icon = _chartIcons.IconChartBarReferenceLine;
      if (frame !== null && frame !== void 0 && frame.datasourceLayers && frame.activeData) {
        const sortedAccessors = (0, _to_expression.getSortedAccessors)(frame.datasourceLayers[layer.layerId], layer);
        palette.push(...(0, _reference_line_helpers.getReferenceConfiguration)({
          state,
          frame: frame,
          layer,
          sortedAccessors
        }).groups.flatMap(({
          accessors
        }) => accessors.map(({
          color
        }) => color)));
      }
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(layer) && layer.annotations && layer.annotations.length) {
      layer.annotations.forEach(annotation => {
        dimensions.push({
          name: _i18n.i18n.translate('xpack.lens.xyChart.layerAnnotation', {
            defaultMessage: 'Annotation'
          }),
          dimensionType: 'annotation',
          id: annotation.id
        });
      });
      label = _i18n.i18n.translate('xpack.lens.xyChart.layerAnnotationsLabel', {
        defaultMessage: 'Annotations'
      });
      icon = _chartIcons.IconChartBarAnnotations;
      palette.push(...layer.annotations.filter(({
        isHidden
      }) => !isHidden).map(annotation => (0, _public.getAnnotationAccessor)(annotation).color));
    }
    const finalPalette = palette === null || palette === void 0 ? void 0 : palette.filter(_utils.nonNullable);
    return {
      layerId: layer.layerId,
      layerType: layer.layerType,
      chartType,
      icon,
      label,
      dimensions,
      palette: finalPalette.length ? finalPalette : undefined
    };
  });
  return {
    layers: visualizationLayersInfo
  };
}
function getNotifiableFeatures(state, frame, paletteService, fieldFormats) {
  const annotationsWithIgnoreFlag = (0, _visualization_helpers.getAnnotationsLayers)(state.layers).filter(layer => layer.ignoreGlobalFilters);
  if (!annotationsWithIgnoreFlag.length) {
    return [];
  }
  const visualizationInfo = getVisualizationInfo(state, frame, paletteService, fieldFormats);
  return [{
    uniqueId: 'ignoring-global-filters-layers',
    severity: 'info',
    fixableInEditor: false,
    shortMessage: _i18n.i18n.translate('xpack.lens.xyChart.layerAnnotationsIgnoreTitle', {
      defaultMessage: 'Layers ignoring global filters'
    }),
    longMessage: /*#__PURE__*/_react.default.createElement(_ignore_global_filter.IgnoredGlobalFiltersEntries, {
      layers: annotationsWithIgnoreFlag.map(({
        layerId,
        indexPatternId
      }) => ({
        layerId,
        indexPatternId
      })),
      visualizationInfo: visualizationInfo,
      dataViews: frame.dataViews
    }),
    displayLocations: [{
      id: 'embeddableBadge'
    }]
  }];
}