"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onSave = exports.getSaveLayerAction = exports.SaveModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _visualization_helpers = require("../../visualization_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** @internal exported for testing only */
const SaveModal = ({
  domElement,
  savedObjectsTagging,
  onSave,
  title,
  description,
  tags,
  showCopyOnSave
}) => {
  const [selectedTags, setSelectedTags] = (0, _react.useState)(tags);
  const closeModal = () => (0, _reactDom.unmountComponentAtNode)(domElement);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
    onSave: async props => onSave({
      ...props,
      closeModal,
      newTags: selectedTags
    }),
    onClose: closeModal,
    title: title,
    description: description,
    showCopyOnSave: showCopyOnSave,
    objectType: _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.objectType', {
      defaultMessage: 'group'
    }),
    customModalTitle: _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.modalTitle', {
      defaultMessage: 'Save annotation group to library'
    }),
    showDescription: true,
    confirmButtonLabel: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "save"
    })), /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.confirmButton', {
      defaultMessage: 'Save group'
    }))),
    options: savedObjectsTagging ? /*#__PURE__*/_react.default.createElement(savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector, {
      initialSelection: selectedTags,
      onTagsSelected: setSelectedTags,
      markOptional: true
    }) : undefined
  });
};
exports.SaveModal = SaveModal;
const saveAnnotationGroupToLibrary = async (layer, {
  newTitle,
  newDescription,
  newTags,
  newCopyOnSave
}, eventAnnotationService, dataViews) => {
  let savedId;
  const dataView = await dataViews.get(layer.indexPatternId);
  const saveAsNew = !(0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer) || newCopyOnSave;
  const groupConfig = {
    annotations: layer.annotations,
    indexPatternId: layer.indexPatternId,
    ignoreGlobalFilters: layer.ignoreGlobalFilters,
    title: newTitle,
    description: newDescription,
    tags: newTags,
    dataViewSpec: dataView.isPersisted() ? undefined : dataView.toSpec(false)
  };
  if (saveAsNew) {
    const {
      id
    } = await eventAnnotationService.createAnnotationGroup(groupConfig);
    savedId = id;
  } else {
    await eventAnnotationService.updateAnnotationGroup(groupConfig, layer.annotationGroupId);
    savedId = layer.annotationGroupId;
  }
  return {
    id: savedId,
    config: groupConfig
  };
};
const shouldStopBecauseDuplicateTitle = async (newTitle, existingTitle, newCopyOnSave, onTitleDuplicate, isTitleDuplicateConfirmed, eventAnnotationService) => {
  if (isTitleDuplicateConfirmed || newTitle === existingTitle && !newCopyOnSave) {
    return false;
  }
  const duplicateExists = await eventAnnotationService.groupExistsWithTitle(newTitle);
  if (duplicateExists) {
    onTitleDuplicate();
    return true;
  } else {
    return false;
  }
};

/** @internal exported for testing only */
const onSave = async ({
  state,
  layer,
  setState,
  registerLibraryAnnotationGroup,
  eventAnnotationService,
  toasts,
  modalOnSaveProps: {
    newTitle,
    newDescription,
    newTags,
    closeModal,
    newCopyOnSave,
    onTitleDuplicate,
    isTitleDuplicateConfirmed
  },
  dataViews,
  goToAnnotationLibrary
}) => {
  const shouldStop = await shouldStopBecauseDuplicateTitle(newTitle, (0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer) ? layer.__lastSaved.title : '', newCopyOnSave, onTitleDuplicate, isTitleDuplicateConfirmed, eventAnnotationService);
  if (shouldStop) return;
  let savedInfo;
  try {
    savedInfo = await saveAnnotationGroupToLibrary(layer, {
      newTitle,
      newDescription,
      newTags,
      newCopyOnSave
    }, eventAnnotationService, dataViews);

    // add new group to state
    registerLibraryAnnotationGroup({
      id: savedInfo.id,
      group: savedInfo.config
    });
  } catch (err) {
    toasts.addError(err, {
      title: _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.errorToastTitle', {
        defaultMessage: 'Failed to save "{title}"',
        values: {
          title: newTitle
        }
      })
    });
    return;
  }
  const newLayer = {
    ...layer,
    annotationGroupId: savedInfo.id,
    __lastSaved: savedInfo.config
  };
  setState({
    ...state,
    layers: state.layers.map(existingLayer => existingLayer.layerId === newLayer.layerId ? newLayer : existingLayer)
  });
  closeModal();
  toasts.addSuccess({
    title: _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.successToastTitle', {
      defaultMessage: 'Saved "{title}"',
      values: {
        title: newTitle
      }
    }),
    text: element => (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.successToastBody",
      defaultMessage: "View or manage in the {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "lnsAnnotationLibraryLink",
          onClick: () => goToAnnotationLibrary()
        }, _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.annotationLibrary', {
          defaultMessage: 'annotation library'
        }))
      }
    })), element)
  });
};
exports.onSave = onSave;
const getSaveLayerAction = ({
  state,
  layer,
  setState,
  registerLibraryAnnotationGroup,
  eventAnnotationService,
  toasts,
  savedObjectsTagging,
  dataViews,
  goToAnnotationLibrary,
  kibanaTheme
}) => {
  const neverSaved = !(0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer);
  const displayName = _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary', {
    defaultMessage: 'Save to library'
  });
  return {
    displayName,
    description: _i18n.i18n.translate('xpack.lens.xyChart.annotations.addAnnotationGroupToLibraryDescription', {
      defaultMessage: 'Saves annotation group as separate saved object'
    }),
    execute: async domElement => {
      if (domElement) {
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
          theme$: kibanaTheme.theme$
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(SaveModal, {
          domElement: domElement,
          savedObjectsTagging: savedObjectsTagging,
          onSave: async props => {
            await onSave({
              state,
              layer,
              setState,
              registerLibraryAnnotationGroup,
              eventAnnotationService,
              toasts,
              modalOnSaveProps: props,
              dataViews,
              goToAnnotationLibrary
            });
          },
          title: neverSaved ? '' : layer.__lastSaved.title,
          description: neverSaved ? '' : layer.__lastSaved.description,
          tags: neverSaved ? [] : layer.__lastSaved.tags,
          showCopyOnSave: !neverSaved
        }))), domElement);
      }
    },
    icon: 'save',
    isCompatible: true,
    'data-test-subj': 'lnsXY_annotationLayer_saveToLibrary',
    order: 100,
    showOutsideList: true
  };
};
exports.getSaveLayerAction = getSaveLayerAction;