"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTagcloudVisualization = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _public3 = require("@kbn/expression-xy-plugin/public");
var _common = require("@kbn/expressions-plugin/common");
var _chartIcons = require("@kbn/chart-icons");
var _suggestions = require("./suggestions");
var _tagcloud_toolbar = require("./tagcloud_toolbar");
var _tags_dimension_editor = require("./tags_dimension_editor");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAG_GROUP_ID = 'tags';
const METRIC_GROUP_ID = 'metric';
const getTagcloudVisualization = ({
  paletteService,
  theme
}) => ({
  id: 'lnsTagcloud',
  visualizationTypes: [{
    id: 'lnsTagcloud',
    icon: _chartIcons.IconChartTagcloud,
    label: _constants.TAGCLOUD_LABEL,
    groupLabel: _i18n.i18n.translate('xpack.lens.pie.groupLabel', {
      defaultMessage: 'Proportion'
    }),
    showExperimentalBadge: true
  }],
  getVisualizationTypeId() {
    return 'lnsTagcloud';
  },
  clearLayer(state) {
    const newState = {
      ...state,
      ..._constants.DEFAULT_STATE
    };
    delete newState.tagAccessor;
    delete newState.valueAccessor;
    delete newState.palette;
    return newState;
  },
  getLayerIds(state) {
    return [state.layerId];
  },
  getDescription() {
    return {
      icon: _chartIcons.IconChartTagcloud,
      label: _constants.TAGCLOUD_LABEL
    };
  },
  getSuggestions: _suggestions.getSuggestions,
  getSuggestionFromConvertToLensContext({
    suggestions,
    context
  }) {
    return !suggestions.length ? undefined : {
      ...suggestions[0],
      visualizationState: {
        ...suggestions[0].visualizationState,
        ...context.configuration
      }
    };
  },
  triggers: [_public2.VIS_EVENT_TO_TRIGGER.filter],
  initialize(addNewLayer, state) {
    return state || {
      layerId: addNewLayer(),
      layerType: _public3.LayerTypes.DATA,
      ..._constants.DEFAULT_STATE
    };
  },
  getConfiguration({
    state
  }) {
    var _state$palette, _state$palette2;
    return {
      groups: [{
        groupId: TAG_GROUP_ID,
        groupLabel: _i18n.i18n.translate('xpack.lens.tagcloud.tagLabel', {
          defaultMessage: 'Tags'
        }),
        layerId: state.layerId,
        accessors: state.tagAccessor ? [{
          columnId: state.tagAccessor,
          triggerIconType: 'colorBy',
          palette: paletteService.get(((_state$palette = state.palette) === null || _state$palette === void 0 ? void 0 : _state$palette.name) || 'default').getCategoricalColors(10, (_state$palette2 = state.palette) === null || _state$palette2 === void 0 ? void 0 : _state$palette2.params)
        }] : [],
        supportsMoreColumns: !state.tagAccessor,
        filterOperations: op => op.isBucketed,
        enableDimensionEditor: true,
        required: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsTagcloud_tagDimensionPanel'
      }, {
        groupId: METRIC_GROUP_ID,
        groupLabel: _i18n.i18n.translate('xpack.lens.tagcloud.metricValueLabel', {
          defaultMessage: 'Metric'
        }),
        isMetricDimension: true,
        layerId: state.layerId,
        accessors: state.valueAccessor ? [{
          columnId: state.valueAccessor
        }] : [],
        supportsMoreColumns: !state.valueAccessor,
        filterOperations: op => !op.isBucketed && op.dataType === 'number',
        enableDimensionEditor: true,
        required: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsTagcloud_valueDimensionPanel'
      }]
    };
  },
  getSupportedLayers() {
    return [{
      type: _public3.LayerTypes.DATA,
      label: _i18n.i18n.translate('xpack.lens.tagcloud.addLayer', {
        defaultMessage: 'Add visualization layer'
      })
    }];
  },
  getLayerType(layerId, state) {
    if ((state === null || state === void 0 ? void 0 : state.layerId) === layerId) {
      return _public3.LayerTypes.DATA;
    }
  },
  toExpression: (state, datasourceLayers, attributes, datasourceExpressionsByLayers = {}) => {
    if (!state.tagAccessor || !state.valueAccessor) {
      return null;
    }
    const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
    return {
      type: 'expression',
      chain: [...(datasourceExpression ? datasourceExpression.chain : []), (0, _common.buildExpressionFunction)('tagcloud', {
        bucket: state.tagAccessor,
        metric: state.valueAccessor,
        maxFontSize: state.maxFontSize,
        minFontSize: state.minFontSize,
        orientation: state.orientation,
        palette: (0, _common.buildExpression)([state.palette ? (0, _common.buildExpressionFunction)('theme', {
          variable: 'palette',
          default: [paletteService.get(state.palette.name).toExpression(state.palette.params)]
        }) : (0, _common.buildExpressionFunction)('system_palette', {
          name: 'default'
        })]).toAst(),
        showLabel: state.showLabel
      }).toAst()]
    };
  },
  toPreviewExpression: (state, datasourceLayers, datasourceExpressionsByLayers = {}) => {
    if (!state.tagAccessor || !state.valueAccessor) {
      return null;
    }
    const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
    return {
      type: 'expression',
      chain: [...(datasourceExpression ? datasourceExpression.chain : []), (0, _common.buildExpressionFunction)('tagcloud', {
        bucket: state.tagAccessor,
        isPreview: true,
        metric: state.valueAccessor,
        maxFontSize: 18,
        minFontSize: 4,
        orientation: state.orientation,
        palette: (0, _common.buildExpression)([state.palette ? (0, _common.buildExpressionFunction)('theme', {
          variable: 'palette',
          default: [paletteService.get(state.palette.name).toExpression(state.palette.params)]
        }) : (0, _common.buildExpressionFunction)('system_palette', {
          name: 'default'
        })]).toAst(),
        showLabel: false
      }).toAst()]
    };
  },
  setDimension({
    columnId,
    groupId,
    prevState
  }) {
    const update = {};
    if (groupId === TAG_GROUP_ID) {
      update.tagAccessor = columnId;
    } else if (groupId === METRIC_GROUP_ID) {
      update.valueAccessor = columnId;
    }
    return {
      ...prevState,
      ...update
    };
  },
  removeDimension({
    prevState,
    layerId,
    columnId
  }) {
    const update = {
      ...prevState
    };
    if (prevState.tagAccessor === columnId) {
      delete update.tagAccessor;
    } else if (prevState.valueAccessor === columnId) {
      delete update.valueAccessor;
    }
    return update;
  },
  renderDimensionEditor(domElement, props) {
    if (props.groupId === TAG_GROUP_ID) {
      (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
        theme$: theme.theme$
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_tags_dimension_editor.TagsDimensionEditor, {
        paletteService: paletteService,
        state: props.state,
        setState: props.setState
      }))), domElement);
    }
  },
  renderToolbar(domElement, props) {
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_tagcloud_toolbar.TagcloudToolbar, props))), domElement);
  }
});
exports.getTagcloudVisualization = getTagcloudVisualization;