"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = void 0;
var _lodash = require("lodash");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
var _public = require("@kbn/expression-xy-plugin/public");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSuggestions = ({
  table,
  state,
  keptLayerIds
}) => {
  var _state$legend$isVisib, _state$legend, _state$legend$positio, _state$legend2, _state$gridConfig$isY, _state$gridConfig, _state$gridConfig$isX, _state$gridConfig2, _state$gridConfig$isY2, _state$gridConfig3, _state$gridConfig$isX2, _state$gridConfig4, _histogram$, _ordinal$, _groups$find;
  if ((state === null || state === void 0 ? void 0 : state.shape) === _constants.CHART_SHAPES.HEATMAP && (state.xAccessor || state.yAccessor || state.valueAccessor) && table.changeType !== 'extended' || table.columns.some(col => col.operation.isStaticValue) ||
  // do not use suggestions with non-numeric metrics
  table.columns.some(col => !col.operation.isBucketed && col.operation.dataType !== 'number')) {
    return [];
  }
  const isUnchanged = state && table.changeType === 'unchanged';
  if (isUnchanged || keptLayerIds.length > 1 || keptLayerIds.length && table.layerId !== keptLayerIds[0]) {
    return [];
  }

  /**
   * The score gets increased based on the config completion.
   */
  let score = 0;
  const [groups, metrics] = (0, _lodash.partition)(table.columns, col => col.operation.isBucketed);
  if (groups.length === 0 && metrics.length === 0) {
    return [];
  }
  if (groups.length >= 3) {
    return [];
  }
  if (metrics.length > 1) {
    return [];
  }
  const isSingleBucketDimension = groups.length === 1 && metrics.length === 0;
  const isOnlyMetricDimension = groups.length === 0 && metrics.length === 1;

  /**
   * Hide for:
   * - reduced and reorder tables
   * - tables with just a single bucket dimension
   * - tables with only date histogram
   */
  const hasOnlyDatehistogramBuckets = metrics.length === 1 && groups.length > 0 && groups.every(group => group.operation.dataType === 'date');
  const hide = table.changeType === 'reduced' || table.changeType === 'reorder' || isSingleBucketDimension || hasOnlyDatehistogramBuckets || isOnlyMetricDimension;
  const newState = {
    shape: _constants.CHART_SHAPES.HEATMAP,
    layerId: table.layerId,
    layerType: _public.LayerTypes.DATA,
    legend: {
      isVisible: (_state$legend$isVisib = state === null || state === void 0 ? void 0 : (_state$legend = state.legend) === null || _state$legend === void 0 ? void 0 : _state$legend.isVisible) !== null && _state$legend$isVisib !== void 0 ? _state$legend$isVisib : true,
      position: (_state$legend$positio = state === null || state === void 0 ? void 0 : (_state$legend2 = state.legend) === null || _state$legend2 === void 0 ? void 0 : _state$legend2.position) !== null && _state$legend$positio !== void 0 ? _state$legend$positio : _charts.Position.Right,
      type: _constants.LEGEND_FUNCTION
    },
    gridConfig: {
      type: _constants.HEATMAP_GRID_FUNCTION,
      isCellLabelVisible: false,
      isYAxisLabelVisible: (_state$gridConfig$isY = state === null || state === void 0 ? void 0 : (_state$gridConfig = state.gridConfig) === null || _state$gridConfig === void 0 ? void 0 : _state$gridConfig.isYAxisLabelVisible) !== null && _state$gridConfig$isY !== void 0 ? _state$gridConfig$isY : true,
      isXAxisLabelVisible: (_state$gridConfig$isX = state === null || state === void 0 ? void 0 : (_state$gridConfig2 = state.gridConfig) === null || _state$gridConfig2 === void 0 ? void 0 : _state$gridConfig2.isXAxisLabelVisible) !== null && _state$gridConfig$isX !== void 0 ? _state$gridConfig$isX : true,
      isYAxisTitleVisible: (_state$gridConfig$isY2 = state === null || state === void 0 ? void 0 : (_state$gridConfig3 = state.gridConfig) === null || _state$gridConfig3 === void 0 ? void 0 : _state$gridConfig3.isYAxisTitleVisible) !== null && _state$gridConfig$isY2 !== void 0 ? _state$gridConfig$isY2 : false,
      isXAxisTitleVisible: (_state$gridConfig$isX2 = state === null || state === void 0 ? void 0 : (_state$gridConfig4 = state.gridConfig) === null || _state$gridConfig4 === void 0 ? void 0 : _state$gridConfig4.isXAxisTitleVisible) !== null && _state$gridConfig$isX2 !== void 0 ? _state$gridConfig$isX2 : false
    }
  };
  const numberMetric = metrics.find(m => m.operation.dataType === 'number');
  if (numberMetric) {
    score += 0.3;
    newState.valueAccessor = numberMetric.columnId;
  }
  const [histogram, ordinal] = (0, _lodash.partition)(groups, g => g.operation.scale === 'interval');
  newState.xAccessor = ((_histogram$ = histogram[0]) === null || _histogram$ === void 0 ? void 0 : _histogram$.columnId) || ((_ordinal$ = ordinal[0]) === null || _ordinal$ === void 0 ? void 0 : _ordinal$.columnId);
  newState.yAccessor = (_groups$find = groups.find(g => g.columnId !== newState.xAccessor)) === null || _groups$find === void 0 ? void 0 : _groups$find.columnId;
  const hasDatehistogram = groups.some(group => group.operation.dataType === 'date');
  if (!hasDatehistogram) {
    if (newState.xAccessor) {
      score += 0.3;
    }
    if (newState.yAccessor) {
      score += 0.3;
    }
  }
  return [{
    state: newState,
    title: _i18n.i18n.translate('xpack.lens.heatmap.heatmapLabel', {
      defaultMessage: 'Heat map'
    }),
    hide,
    previewIcon: _chartIcons.IconChartHeatmap,
    score: Number(score.toFixed(1)),
    incomplete: isSingleBucketDimension || isOnlyMetricDimension
  }];
};
exports.getSuggestions = getSuggestions;