"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.execute = execute;
exports.getHref = getHref;
exports.getLocation = getLocation;
exports.isCompatible = isCompatible;
exports.isLensEmbeddable = isLensEmbeddable;
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function isLensEmbeddable(embeddable) {
  return embeddable.type === _constants.DOC_TYPE;
}
async function isCompatible({
  hasDiscoverAccess,
  embeddable
}) {
  if (!hasDiscoverAccess) return false;
  try {
    return isLensEmbeddable(embeddable) && (await embeddable.canViewUnderlyingData());
  } catch (e) {
    // Fetching underlying data failed, log the error and behave as if the action is not compatible
    // eslint-disable-next-line no-console
    console.error(e);
    return false;
  }
}
async function getDiscoverLocationParams({
  embeddable,
  filters,
  dataViews,
  timeFieldName
}) {
  if (!isLensEmbeddable(embeddable)) {
    // shouldn't be executed because of the isCompatible check
    throw new Error('Can only be executed in the context of Lens visualization');
  }
  const args = embeddable.getViewUnderlyingDataArgs();
  if (!args) {
    // shouldn't be executed because of the isCompatible check
    throw new Error('Underlying data is not ready');
  }
  const dataView = await dataViews.get(args.dataViewSpec.id);
  let filtersToApply = [...(filters || []), ...args.filters];
  let timeRangeToApply = args.timeRange;
  // if the target data view is time based, attempt to split out a time range from the provided filters
  if (dataView.isTimeBased() && dataView.timeFieldName === timeFieldName) {
    const {
      extractTimeRange
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
    const {
      restOfFilters,
      timeRange
    } = extractTimeRange(filters || [], timeFieldName);
    filtersToApply = restOfFilters;
    if (timeRange) {
      timeRangeToApply = timeRange;
    }
  }
  return {
    ...args,
    timeRange: timeRangeToApply,
    filters: filtersToApply
  };
}
async function getHref({
  embeddable,
  locator,
  filters,
  dataViews,
  timeFieldName
}) {
  const params = await getDiscoverLocationParams({
    embeddable,
    filters,
    dataViews,
    timeFieldName
  });
  const discoverUrl = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl(params);
  return discoverUrl;
}
async function getLocation({
  embeddable,
  locator,
  filters,
  dataViews,
  timeFieldName
}) {
  const params = await getDiscoverLocationParams({
    embeddable,
    filters,
    dataViews,
    timeFieldName
  });
  const discoverLocation = locator === null || locator === void 0 ? void 0 : locator.getLocation(params);
  if (!discoverLocation) {
    throw new Error('Discover location not found');
  }
  return discoverLocation;
}
async function execute({
  embeddable,
  locator,
  filters,
  openInSameTab,
  dataViews,
  timeFieldName,
  hasDiscoverAccess
}) {
  const discoverUrl = await getHref({
    embeddable,
    locator,
    filters,
    dataViews,
    timeFieldName,
    hasDiscoverAccess
  });
  window.open(discoverUrl, !openInSameTab ? '_blank' : '_self');
}