"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  loadInitial: true,
  navigateAway: true,
  setState: true,
  enableAutoApply: true,
  disableAutoApply: true,
  applyChanges: true,
  setSaveable: true,
  onActiveDataChange: true,
  updateState: true,
  updateDatasourceState: true,
  updateVisualizationState: true,
  insertLayer: true,
  switchVisualization: true,
  rollbackSuggestion: true,
  submitSuggestion: true,
  switchDatasource: true,
  switchAndCleanDatasource: true,
  updateIndexPatterns: true,
  setToggleFullscreen: true,
  initEmpty: true,
  editVisualizationAction: true,
  removeLayers: true,
  removeOrClearLayer: true,
  cloneLayer: true,
  addLayer: true,
  setLayerDefaultDimension: true,
  removeDimension: true,
  setIsLoadLibraryVisible: true,
  registerLibraryAnnotationGroup: true,
  makeConfigureStore: true,
  useLensDispatch: true,
  useLensSelector: true
};
exports.useLensSelector = exports.useLensDispatch = exports.updateVisualizationState = exports.updateState = exports.updateIndexPatterns = exports.updateDatasourceState = exports.switchVisualization = exports.switchDatasource = exports.switchAndCleanDatasource = exports.submitSuggestion = exports.setToggleFullscreen = exports.setState = exports.setSaveable = exports.setLayerDefaultDimension = exports.setIsLoadLibraryVisible = exports.rollbackSuggestion = exports.removeOrClearLayer = exports.removeLayers = exports.removeDimension = exports.registerLibraryAnnotationGroup = exports.onActiveDataChange = exports.navigateAway = exports.makeConfigureStore = exports.loadInitial = exports.insertLayer = exports.initEmpty = exports.enableAutoApply = exports.editVisualizationAction = exports.disableAutoApply = exports.cloneLayer = exports.applyChanges = exports.addLayer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _reduxLogger = require("redux-logger");
var _reactRedux = require("react-redux");
var _lens_slice = require("./lens_slice");
var _init_middleware = require("./init_middleware");
var _optimizing_middleware = require("./optimizing_middleware");
var _context_middleware = require("./context_middleware");
var _fullscreen_middleware = require("./fullscreen_middleware");
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  loadInitial,
  navigateAway,
  setState,
  enableAutoApply,
  disableAutoApply,
  applyChanges,
  setSaveable,
  onActiveDataChange,
  updateState,
  updateDatasourceState,
  updateVisualizationState,
  insertLayer,
  switchVisualization,
  rollbackSuggestion,
  submitSuggestion,
  switchDatasource,
  switchAndCleanDatasource,
  updateIndexPatterns,
  setToggleFullscreen,
  initEmpty,
  editVisualizationAction,
  removeLayers,
  removeOrClearLayer,
  cloneLayer,
  addLayer,
  setLayerDefaultDimension,
  removeDimension,
  setIsLoadLibraryVisible,
  registerLibraryAnnotationGroup
} = _lens_slice.lensActions;
exports.registerLibraryAnnotationGroup = registerLibraryAnnotationGroup;
exports.setIsLoadLibraryVisible = setIsLoadLibraryVisible;
exports.removeDimension = removeDimension;
exports.setLayerDefaultDimension = setLayerDefaultDimension;
exports.addLayer = addLayer;
exports.cloneLayer = cloneLayer;
exports.removeOrClearLayer = removeOrClearLayer;
exports.removeLayers = removeLayers;
exports.editVisualizationAction = editVisualizationAction;
exports.initEmpty = initEmpty;
exports.setToggleFullscreen = setToggleFullscreen;
exports.updateIndexPatterns = updateIndexPatterns;
exports.switchAndCleanDatasource = switchAndCleanDatasource;
exports.switchDatasource = switchDatasource;
exports.submitSuggestion = submitSuggestion;
exports.rollbackSuggestion = rollbackSuggestion;
exports.switchVisualization = switchVisualization;
exports.insertLayer = insertLayer;
exports.updateVisualizationState = updateVisualizationState;
exports.updateDatasourceState = updateDatasourceState;
exports.updateState = updateState;
exports.onActiveDataChange = onActiveDataChange;
exports.setSaveable = setSaveable;
exports.applyChanges = applyChanges;
exports.disableAutoApply = disableAutoApply;
exports.enableAutoApply = enableAutoApply;
exports.setState = setState;
exports.navigateAway = navigateAway;
exports.loadInitial = loadInitial;
const makeConfigureStore = (storeDeps, preloadedState) => {
  const middleware = [...(0, _toolkit.getDefaultMiddleware)({
    serializableCheck: false
  }), (0, _init_middleware.initMiddleware)(storeDeps), (0, _optimizing_middleware.optimizingMiddleware)(), (0, _context_middleware.contextMiddleware)(storeDeps), (0, _fullscreen_middleware.fullscreenMiddleware)(storeDeps)];
  if (process.env.NODE_ENV === 'development') {
    middleware.push((0, _reduxLogger.createLogger)({
      // @ts-ignore
      predicate: () => window.ELASTIC_LENS_LOGGER
    }));
  }
  return (0, _toolkit.configureStore)({
    reducer: {
      lens: (0, _lens_slice.makeLensReducer)(storeDeps)
    },
    middleware,
    preloadedState
  });
};
exports.makeConfigureStore = makeConfigureStore;
const useLensDispatch = () => (0, _reactRedux.useDispatch)();
exports.useLensDispatch = useLensDispatch;
const useLensSelector = _reactRedux.useSelector;
exports.useLensSelector = useLensSelector;