"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestionsApi = void 0;
var _suggestion_helpers = require("./editor_frame_service/editor_frame/suggestion_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const suggestionsApi = ({
  context,
  dataView,
  datasourceMap,
  visualizationMap,
  excludedVisualizations
}) => {
  if (!datasourceMap || !visualizationMap || !dataView.id) return undefined;
  const datasourceStates = {
    formBased: {
      isLoading: false,
      state: {
        layers: {}
      }
    },
    textBased: {
      isLoading: false,
      state: {
        layers: {},
        fieldList: [],
        indexPatternRefs: [],
        initialContext: context
      }
    }
  };
  const currentDataViewId = dataView.id;
  const dataViews = {
    indexPatterns: {
      [currentDataViewId]: dataView
    },
    indexPatternRefs: []
  };
  const initialVisualization = (visualizationMap === null || visualizationMap === void 0 ? void 0 : visualizationMap[Object.keys(visualizationMap)[0]]) || null;

  // find the active visualizations from the context
  const suggestions = (0, _suggestion_helpers.getSuggestions)({
    datasourceMap,
    datasourceStates,
    visualizationMap,
    activeVisualization: initialVisualization,
    visualizationState: undefined,
    visualizeTriggerFieldContext: context,
    dataViews
  });
  if (!suggestions.length) return [];
  const activeVisualization = suggestions[0];
  if (activeVisualization.incomplete || excludedVisualizations !== null && excludedVisualizations !== void 0 && excludedVisualizations.includes(activeVisualization.visualizationId)) {
    return [];
  }
  // compute the rest suggestions depending on the active one and filter out the lnsLegacyMetric
  const newSuggestions = (0, _suggestion_helpers.getSuggestions)({
    datasourceMap,
    datasourceStates: {
      textBased: {
        isLoading: false,
        state: activeVisualization.datasourceState
      }
    },
    visualizationMap,
    activeVisualization: visualizationMap[activeVisualization.visualizationId],
    visualizationState: activeVisualization.visualizationState,
    dataViews
  }).filter(sug => !sug.hide && sug.visualizationId !== 'lnsLegacyMetric');
  return [activeVisualization, ...newSuggestions];
};
exports.suggestionsApi = suggestionsApi;