"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFeatureBadge = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
require("./embeddable_info_badges.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmbeddableFeatureBadge = ({
  messages
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(isOpen => !isOpen);
  const closePopover = () => setIsPopoverOpen(false);
  if (!messages.length) {
    return null;
  }
  const iconTitle = _i18n.i18n.translate('xpack.lens.embeddable.featureBadge.iconDescription', {
    defaultMessage: `{count} visualization {count, plural, one {modifier} other {modifiers}}`,
    values: {
      count: messages.length
    }
  });
  const messagesWithoutUniqueId = messages.filter(({
    uniqueId
  }) => !uniqueId);
  // compact messages be grouping longMessage together on matching unique-id
  const messagesGroupedByUniqueId = {};
  for (const message of messages) {
    if (message.uniqueId) {
      if (!messagesGroupedByUniqueId[message.uniqueId]) {
        messagesGroupedByUniqueId[message.uniqueId] = [];
      }
      messagesGroupedByUniqueId[message.uniqueId].push(message);
    }
  }
  const messageCount = messagesWithoutUniqueId.length + Object.keys(messagesGroupedByUniqueId).length;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      content: iconTitle
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "lns-feature-badges-trigger",
      className: "lnsEmbeddablePanelFeatureList_button",
      color: 'text',
      onClick: onButtonClick,
      title: iconTitle,
      size: "s",
      css: (0, _react.css)`
              color: transparent;
              font-size: ${xsFontSize};
              height: ${euiTheme.size.l} !important;
              .euiButtonEmpty__content {
                padding: 0 ${euiTheme.size.xs};
              }
              .euiButtonEmpty__text {
                margin-inline-start: ${euiTheme.size.xs};
              }
            `,
      iconType: "wrench"
    }, messageCount)),
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          max-width: 280px;
        `,
    "data-test-subj": "lns-feature-badges-panel"
  }, messagesWithoutUniqueId.map(({
    shortMessage,
    longMessage
  }, index) => {
    return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      key: `${shortMessage}-${index}`
    }, index ? /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none",
      "data-test-subj": "lns-feature-badges-horizontal-rule"
    }) : null, /*#__PURE__*/_react2.default.createElement("aside", {
      css: (0, _react.css)`
                  padding: ${euiTheme.size.base};
                `
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: (0, _react.css)`color=${euiTheme.colors.title}`
    }, /*#__PURE__*/_react2.default.createElement("h3", null, shortMessage)), /*#__PURE__*/_react2.default.createElement("ul", {
      className: "lnsEmbeddablePanelFeatureList"
    }, longMessage)));
  }), Object.entries(messagesGroupedByUniqueId).map(([uniqueId, messagesByUniqueId], index) => {
    const hasHorizontalRule = messagesWithoutUniqueId.length || index;
    const [{
      shortMessage
    }] = messagesByUniqueId;
    return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      key: uniqueId
    }, hasHorizontalRule ? /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none",
      "data-test-subj": "lns-feature-badges-horizontal-rule"
    }) : null, /*#__PURE__*/_react2.default.createElement("aside", {
      css: (0, _react.css)`
                  padding: ${euiTheme.size.base};
                `
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: (0, _react.css)`color=${euiTheme.colors.title}`
    }, /*#__PURE__*/_react2.default.createElement("h3", null, shortMessage)), /*#__PURE__*/_react2.default.createElement("ul", {
      className: "lnsEmbeddablePanelFeatureList"
    }, messagesByUniqueId.map(({
      longMessage
    }, i) => /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      key: `${uniqueId}-${i}`
    }, longMessage)))));
  })));
};
exports.EmbeddableFeatureBadge = EmbeddableFeatureBadge;