"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerPanel = LayerPanel;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _dataview_picker = require("../../shared_components/dataview_picker/dataview_picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LayerPanel({
  state,
  layerId,
  dataViews
}) {
  const layer = state.layers[layerId];
  const dataView = state.indexPatternRefs.find(ref => ref.id === layer.index);
  const notFoundTitleLabel = _i18n.i18n.translate('xpack.lens.layerPanel.missingDataView', {
    defaultMessage: 'Data view not found'
  });
  return /*#__PURE__*/_react.default.createElement(_dataview_picker.ChangeIndexPattern, {
    "data-test-subj": "textBasedLanguages-switcher",
    trigger: {
      label: (dataView === null || dataView === void 0 ? void 0 : dataView.name) || (dataView === null || dataView === void 0 ? void 0 : dataView.title) || notFoundTitleLabel,
      title: (dataView === null || dataView === void 0 ? void 0 : dataView.title) || notFoundTitleLabel,
      size: 's',
      fontWeight: 'normal',
      isDisabled: true
    },
    indexPatternId: layer.index,
    indexPatternRefs: dataViews.indexPatternRefs,
    isMissingCurrent: !dataView,
    onChangeIndexPattern: () => {}
  });
}