"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelect = FieldSelect;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/visualization-ui-components/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldSelect({
  selectedField,
  onChoose,
  existingFields,
  ['data-test-subj']: dataTestSub
}) {
  var _selectedField$meta;
  const memoizedFieldOptions = (0, _react.useMemo)(() => {
    const availableFields = existingFields.map(field => {
      var _field$meta;
      const dataType = field === null || field === void 0 ? void 0 : (_field$meta = field.meta) === null || _field$meta === void 0 ? void 0 : _field$meta.type;
      return {
        compatible: field.compatible ? 1 : 0,
        exists: true,
        label: field.name,
        value: {
          type: 'field',
          field: field.name,
          dataType
        }
      };
    }).sort((a, b) => b.compatible - a.compatible);
    return [{
      label: _i18n.i18n.translate('xpack.lens.indexPattern.availableFieldsLabel', {
        defaultMessage: 'Available fields'
      }),
      options: availableFields
    }];
  }, [existingFields]);
  return /*#__PURE__*/_react.default.createElement(_public.FieldPicker, {
    selectedOptions: selectedField ? [{
      label: selectedField.fieldName,
      value: {
        type: 'field',
        field: selectedField.fieldName,
        dataType: selectedField === null || selectedField === void 0 ? void 0 : (_selectedField$meta = selectedField.meta) === null || _selectedField$meta === void 0 ? void 0 : _selectedField$meta.type
      }
    }] : [],
    options: memoizedFieldOptions,
    onChoose: choice => {
      if (choice && choice.field !== (selectedField === null || selectedField === void 0 ? void 0 : selectedField.fieldName)) {
        onChoose(choice);
      }
    },
    fieldIsInvalid: false,
    "data-test-subj": dataTestSub !== null && dataTestSub !== void 0 ? dataTestSub : 'text-based-dimension-field'
  });
}