"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnOrder = getColumnOrder;
exports.intervalOperation = void 0;
exports.isColumnOfType = isColumnOfType;
exports.timeRangeOperation = exports.nowOperation = void 0;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _common = require("@kbn/data-plugin/common");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// copied over from layer_helpers
// TODO: split layer_helpers util into pure/non-pure functions to avoid issues with tests
function getColumnOrder(layer) {
  const entries = Object.entries(layer.columns);
  entries.sort(([idA], [idB]) => {
    const indexA = layer.columnOrder.indexOf(idA);
    const indexB = layer.columnOrder.indexOf(idB);
    if (indexA > -1 && indexB > -1) {
      return indexA - indexB;
    } else if (indexA > -1) {
      return -1;
    } else {
      return 1;
    }
  });
  const [aggregations, metrics] = (0, _lodash.partition)(entries, ([, col]) => col.isBucketed);
  return aggregations.map(([id]) => id).concat(metrics.map(([id]) => id));
}

// Copied over from helpers
function isColumnOfType(type, column) {
  return column.operationType === type;
}
function getTimeRangeFromContext({
  dateRange
}) {
  return dateRange ? (0, _moment.default)(dateRange.toDate).diff((0, _moment.default)(dateRange.fromDate)) : 0;
}
function getTimeRangeErrorMessages(layer, columnId, indexPattern, dateRange) {
  const errors = [];
  if (!indexPattern.timeFieldName) {
    errors.push(_i18n.i18n.translate('xpack.lens.indexPattern.dateRange.dataViewNoTimeBased', {
      defaultMessage: 'The current dataView is not time based'
    }));
  }
  if (!dateRange) {
    errors.push(_i18n.i18n.translate('xpack.lens.indexPattern.dateRange.noTimeRange', {
      defaultMessage: 'The current time range interval is not available'
    }));
  }
  return errors.length ? errors : undefined;
}
const timeRangeOperation = createContextValueBasedOperation({
  type: 'time_range',
  label: 'Time range',
  description: _i18n.i18n.translate('xpack.lens.indexPattern.timeRange.documentation.markdown', {
    defaultMessage: `
The specified time range, in milliseconds (ms).
    `
  }),
  getContextValue: getTimeRangeFromContext,
  getErrorMessage: getTimeRangeErrorMessages
});
exports.timeRangeOperation = timeRangeOperation;
function getNowFromContext({
  now
}) {
  return now == null ? Date.now() : +now;
}
function getNowErrorMessage() {
  return undefined;
}
const nowOperation = createContextValueBasedOperation({
  type: 'now',
  label: 'Current now',
  description: _i18n.i18n.translate('xpack.lens.indexPattern.now.documentation.markdown', {
    defaultMessage: `
  The current now moment used in Kibana expressed in milliseconds (ms).
      `
  }),
  getContextValue: getNowFromContext,
  getErrorMessage: getNowErrorMessage
});
exports.nowOperation = nowOperation;
function getIntervalFromContext(context) {
  return context.dateRange && context.targetBars ? (0, _common.calcAutoIntervalNear)(context.targetBars, getTimeRangeFromContext(context)).asMilliseconds() : 0;
}
function getIntervalErrorMessages(layer, columnId, indexPattern, dateRange, operationDefinitionMap, targetBars) {
  const errors = [];
  if (!targetBars) {
    errors.push(_i18n.i18n.translate('xpack.lens.indexPattern.interval.noTargetBars', {
      defaultMessage: `Missing "{uiSettingVar}" value`,
      values: {
        uiSettingVar: _common.UI_SETTINGS.HISTOGRAM_BAR_TARGET
      }
    }));
  }
  if (!dateRange) {
    errors.push(_i18n.i18n.translate('xpack.lens.indexPattern.interval.noTimeRange', {
      defaultMessage: 'The current time range interval is not available'
    }));
  }
  if (!Object.values(layer.columns).some(column => isColumnOfType('date_histogram', column))) {
    errors.push(_i18n.i18n.translate('xpack.lens.indexPattern.interval.noDateHistogramColumn', {
      defaultMessage: 'Cannot compute an interval without a date histogram column configured'
    }));
  }
  return errors.length ? errors : undefined;
}
const intervalOperation = createContextValueBasedOperation({
  type: 'interval',
  label: 'Date histogram interval',
  description: _i18n.i18n.translate('xpack.lens.indexPattern.interval.documentation.markdown', {
    defaultMessage: `
The specified minimum interval for the date histogram, in milliseconds (ms).
      `
  }),
  getContextValue: getIntervalFromContext,
  getErrorMessage: getIntervalErrorMessages
});
exports.intervalOperation = intervalOperation;
function createContextValueBasedOperation({
  label,
  type,
  getContextValue,
  getErrorMessage,
  description
}) {
  return {
    type,
    displayName: label,
    input: 'managedReference',
    selectionStyle: 'hidden',
    usedInMath: true,
    getDefaultLabel: () => label,
    isTransferable: () => true,
    getDisabledStatus() {
      return undefined;
    },
    getErrorMessage,
    getPossibleOperation() {
      return {
        dataType: 'number',
        isBucketed: false,
        scale: 'ratio'
      };
    },
    buildColumn: () => {
      return {
        label,
        dataType: 'number',
        operationType: type,
        isBucketed: false,
        scale: 'ratio',
        references: []
      };
    },
    toExpression: (layer, columnId, _, context = {}) => {
      const column = layer.columns[columnId];
      return [{
        type: 'function',
        function: 'mathColumn',
        arguments: {
          id: [columnId],
          name: [column.label],
          expression: [String(getContextValue(context))]
        }
      }];
    },
    createCopy(layers, source, target) {
      const currentColumn = layers[source.layerId].columns[source.columnId];
      const targetLayer = layers[target.layerId];
      const columns = {
        ...targetLayer.columns,
        [target.columnId]: {
          ...currentColumn
        }
      };
      return {
        ...layers,
        [target.layerId]: {
          ...targetLayer,
          columns,
          columnOrder: getColumnOrder({
            ...targetLayer,
            columns
          })
        }
      };
    },
    documentation: {
      section: 'constants',
      signature: '',
      description
    }
  };
}