"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filtersOperation = exports.defaultLabel = exports.FilterList = void 0;
require("./filters.scss");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/data-plugin/common");
var _public = require("@kbn/expressions-plugin/public");
var _public2 = require("@kbn/visualization-ui-components/public");
var _layer_helpers = require("../../layer_helpers");
var _filter_popover = require("./filter_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateId = (0, _eui.htmlIdGenerator)();
const OPERATION_NAME = 'filters';

// references types from src/plugins/data/common/search/aggs/buckets/filters.ts

const filtersLabel = _i18n.i18n.translate('xpack.lens.indexPattern.filters', {
  defaultMessage: 'Filters'
});
const defaultLabel = _i18n.i18n.translate('xpack.lens.indexPattern.filters.label.placeholder', {
  defaultMessage: 'All records'
});

// to do: get the language from uiSettings
exports.defaultLabel = defaultLabel;
const defaultFilter = {
  input: {
    query: '',
    language: 'kuery'
  },
  label: ''
};
const filtersOperation = {
  type: OPERATION_NAME,
  displayName: filtersLabel,
  priority: 3,
  // Higher than any metric
  input: 'none',
  isTransferable: () => true,
  getDefaultLabel: () => filtersLabel,
  buildColumn({
    previousColumn
  }, columnParams) {
    var _columnParams$filters;
    let params = {
      filters: (_columnParams$filters = columnParams === null || columnParams === void 0 ? void 0 : columnParams.filters) !== null && _columnParams$filters !== void 0 ? _columnParams$filters : [defaultFilter]
    };
    if ((previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.operationType) === 'terms' && 'sourceField' in previousColumn) {
      var _columnParams$filters2, _params$secondaryFiel, _params, _params$secondaryFiel2;
      params = {
        filters: (_columnParams$filters2 = columnParams === null || columnParams === void 0 ? void 0 : columnParams.filters) !== null && _columnParams$filters2 !== void 0 ? _columnParams$filters2 : [{
          label: '',
          input: {
            query: `${previousColumn.sourceField} : *`,
            language: 'kuery'
          }
        }, ...((_params$secondaryFiel = (_params = previousColumn.params) === null || _params === void 0 ? void 0 : (_params$secondaryFiel2 = _params.secondaryFields) === null || _params$secondaryFiel2 === void 0 ? void 0 : _params$secondaryFiel2.map(field => ({
          label: '',
          input: {
            query: `${field} : *`,
            language: 'kuery'
          }
        }))) !== null && _params$secondaryFiel !== void 0 ? _params$secondaryFiel : [])]
      };
    }
    return {
      label: filtersLabel,
      dataType: 'string',
      operationType: OPERATION_NAME,
      scale: 'ordinal',
      isBucketed: true,
      params
    };
  },
  getPossibleOperation() {
    return {
      dataType: 'string',
      isBucketed: true,
      scale: 'ordinal'
    };
  },
  toEsAggsFn: (column, columnId, indexPattern) => {
    var _column$params$filter;
    const validFilters = (_column$params$filter = column.params.filters) === null || _column$params$filter === void 0 ? void 0 : _column$params$filter.filter(f => (0, _public2.isQueryValid)(f.input, indexPattern));
    return (0, _public.buildExpressionFunction)('aggFilters', {
      id: columnId,
      enabled: true,
      schema: 'segment',
      filters: ((validFilters === null || validFilters === void 0 ? void 0 : validFilters.length) > 0 ? validFilters : [defaultFilter]).map(_common.queryFilterToAst)
    }).toAst();
  },
  paramEditor: ({
    layer,
    columnId,
    currentColumn,
    indexPattern,
    paramEditorUpdater
  }) => {
    const filters = currentColumn.params.filters;
    const setFilters = newFilters => paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
      layer,
      columnId,
      paramName: OPERATION_NAME,
      value: newFilters
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(FilterList, {
      filters: filters,
      setFilters: setFilters,
      indexPattern: indexPattern,
      defaultQuery: defaultFilter
    }));
  },
  getMaxPossibleNumValues: column => column.params.filters.length,
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.filters.documentation.quick', {
    defaultMessage: `
    Divides values into predefined subsets.
      `
  })
};
exports.filtersOperation = filtersOperation;
const FilterList = ({
  filters,
  setFilters,
  indexPattern,
  defaultQuery
}) => {
  const [activeFilterId, setActiveFilterId] = (0, _react.useState)('');
  const [localFilters, setLocalFilters] = (0, _react.useState)(() => filters.map(filter => ({
    ...filter,
    id: generateId()
  })));
  const updateFilters = updatedFilters => {
    // do not set internal id parameter into saved object
    setFilters(updatedFilters.map(filter => (0, _lodash.omit)(filter, 'id')));
    setLocalFilters(updatedFilters);
  };
  const onAddFilter = () => {
    const newFilterId = generateId();
    updateFilters([...localFilters, {
      ...defaultQuery,
      id: newFilterId
    }]);
    setActiveFilterId(newFilterId);
  };
  const onRemoveFilter = id => updateFilters(localFilters.filter(filter => filter.id !== id));
  const onChangeValue = (id, query, label) => updateFilters(localFilters.map(filter => filter.id === id ? {
    ...filter,
    input: query,
    label
  } : filter));
  const changeActiveFilter = filterId => {
    let newActiveFilterId = filterId;
    if (activeFilterId === filterId) {
      newActiveFilterId = ''; // toggle off
    }

    setActiveFilterId(newActiveFilterId);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public2.DragDropBuckets, {
    onDragEnd: updateFilters,
    onDragStart: () => {},
    droppableId: "FILTERS_DROPPABLE_AREA",
    items: localFilters
  }, localFilters === null || localFilters === void 0 ? void 0 : localFilters.map((filter, idx, arrayRef) => {
    const isInvalid = !(0, _public2.isQueryValid)(filter.input, indexPattern);
    const id = filter.id;
    return /*#__PURE__*/_react.default.createElement(_public2.DraggableBucketContainer, {
      id: id,
      key: id,
      idx: idx,
      isInvalid: isInvalid,
      invalidMessage: _i18n.i18n.translate('xpack.lens.indexPattern.filters.isInvalid', {
        defaultMessage: 'This query is invalid'
      }),
      onRemoveClick: () => onRemoveFilter(filter.id),
      removeTitle: _i18n.i18n.translate('xpack.lens.indexPattern.filters.removeFilter', {
        defaultMessage: 'Remove a filter'
      }),
      isNotRemovable: arrayRef.length === 1,
      isNotDraggable: arrayRef.length === 1
    }, /*#__PURE__*/_react.default.createElement(_filter_popover.FilterPopover, {
      "data-test-subj": "indexPattern-filters-existingFilterContainer",
      isOpen: filter.id === activeFilterId,
      triggerClose: () => changeActiveFilter(''),
      indexPattern: indexPattern,
      filter: filter,
      setFilter: f => {
        onChangeValue(f.id, f.input, f.label);
      },
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        className: "lnsFiltersOperation__popoverButton",
        "data-test-subj": "indexPattern-filters-existingFilterTrigger",
        onClick: () => changeActiveFilter(filter.id),
        color: isInvalid ? 'danger' : 'text',
        title: _i18n.i18n.translate('xpack.lens.indexPattern.filters.clickToEdit', {
          defaultMessage: 'Click to edit'
        })
      }, filter.label || filter.input.query || defaultLabel)
    }));
  })), /*#__PURE__*/_react.default.createElement(_public2.NewBucketButton, {
    onClick: () => {
      onAddFilter();
    },
    label: _i18n.i18n.translate('xpack.lens.indexPattern.filters.addaFilter', {
      defaultMessage: 'Add a filter'
    })
  }));
};
exports.FilterList = FilterList;