"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeQueryParam = removeQueryParam;
var _queryString = require("query-string");
var _common = require("../../common");
var _get_query_params = require("./get_query_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function removeQueryParam(history, param, replace = true) {
  const oldLocation = history.location;
  const query = (0, _get_query_params.getQueryParams)(oldLocation);
  delete query[param];
  const newSearch = (0, _queryString.stringify)(_common.url.encodeQuery(query), {
    sort: false,
    encode: false
  });
  const newLocation = {
    ...oldLocation,
    search: newSearch
  };
  if (replace) {
    history.replace(newLocation);
  } else {
    history.push(newLocation);
  }
}