"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encodeState = encodeState;
var _rison = _interopRequireDefault(require("@kbn/rison"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// should be:
// export function encodeState<State extends RisonValue> but this leads to the chain of
// types mismatches up to BaseStateContainer interfaces, as in state containers we don't
// have any restrictions on state shape
function encodeState(state, useHash, createHash) {
  if (useHash) {
    return createHash(state);
  } else {
    var _rison$encodeUnknown;
    return (_rison$encodeUnknown = _rison.default.encodeUnknown(state)) !== null && _rison$encodeUnknown !== void 0 ? _rison$encodeUnknown : '';
  }
}