"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUiSetting$ = exports.useUiSetting = exports.useGlobalUiSetting$ = exports.useGlobalUiSetting = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _context = require("../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Returns the current UI-settings value.
 *
 * Usage:
 *
 * ```js
 * const darkMode = useUiSetting('theme:darkMode');
 * ```
 */
const useUiSetting = (key, defaultValue) => {
  const {
    services: {
      settings
    }
  } = (0, _context.useKibana)();
  if (!settings) {
    throw new TypeError('uiSettings service not available in kibana-react context.');
  }
  return settings.client.get(key, defaultValue);
};

/**
 * Returns the current global UI-settings value.
 *
 * Usage:
 *
 * ```js
 * const customBranding = useGlobalUiSetting('customBranding:pageTitle');
 * ```
 */
exports.useUiSetting = useUiSetting;
const useGlobalUiSetting = (key, defaultValue) => {
  const {
    services: {
      settings
    }
  } = (0, _context.useKibana)();
  if (!settings) {
    throw new TypeError('uiSettings service not available in kibana-react context.');
  }
  return settings.globalClient.get(key, defaultValue);
};
exports.useGlobalUiSetting = useGlobalUiSetting;
/**
 * Returns a 2-tuple, where first entry is the setting value and second is a
 * function to update the setting value.
 *
 * Synchronously returns the most current value of the setting and subscribes
 * to all subsequent updates, which will re-render your component on new values.
 *
 * Usage:
 *
 * ```js
 * const [darkMode, setDarkMode] = useUiSetting$('theme:darkMode');
 * ```
 */
const useUiSetting$ = (key, defaultValue) => {
  const {
    services: {
      settings
    }
  } = (0, _context.useKibana)();
  if (!settings) {
    throw new TypeError('uiSettings service not available in kibana-react context.');
  }
  const observable$ = (0, _react.useMemo)(() => settings.client.get$(key, defaultValue), [key, defaultValue, settings]);
  const value = (0, _useObservable.default)(observable$, settings.client.get(key, defaultValue));
  const set = (0, _react.useCallback)(newValue => settings.client.set(key, newValue), [key]);
  return [value, set];
};

/**
 * Returns a 2-tuple, where first entry is the setting value and second is a
 * function to update the setting value.
 *
 * Synchronously returns the most current value of the setting and subscribes
 * to all subsequent updates, which will re-render your component on new values.
 *
 * Usage:
 *
 * ```js
 * const [customBranding, setCustomBranding] = useGlobalUiSetting$('customBranding:pageTitle');
 * ```
 */
exports.useUiSetting$ = useUiSetting$;
const useGlobalUiSetting$ = (key, defaultValue) => {
  const {
    services: {
      settings
    }
  } = (0, _context.useKibana)();
  if (!settings) {
    throw new TypeError('uiSettings service not available in kibana-react context.');
  }
  const observable$ = (0, _react.useMemo)(() => settings.globalClient.get$(key, defaultValue), [key, defaultValue, settings.globalClient]);
  const value = (0, _useObservable.default)(observable$, settings.globalClient.get(key, defaultValue));
  const set = (0, _react.useCallback)(newValue => settings.globalClient.set(key, newValue), [key]);
  return [value, set];
};
exports.useGlobalUiSetting$ = useGlobalUiSetting$;