"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSolutionNav = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _solution_nav = require("./solution_nav");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// https://reactjs.org/docs/higher-order-components.html#convention-wrap-the-display-name-for-easy-debugging
function getDisplayName(Component) {
  return Component.displayName || Component.name || 'UnnamedComponent';
}
const SOLUTION_NAV_COLLAPSED_KEY = 'solutionNavIsCollapsed';
const withSolutionNav = WrappedComponent => {
  const WithSolutionNav = props => {
    var _props$pageSideBarPro;
    const isMediumBreakpoint = (0, _eui.useIsWithinBreakpoints)(['m']);
    const isLargerBreakpoint = (0, _eui.useIsWithinBreakpoints)(['l', 'xl']);
    const [isSideNavOpenOnDesktop, setisSideNavOpenOnDesktop] = (0, _react.useState)(!JSON.parse(String(localStorage.getItem(SOLUTION_NAV_COLLAPSED_KEY))));
    const {
      solutionNav,
      ...propagatedProps
    } = props;
    const {
      children,
      isEmptyState,
      template
    } = propagatedProps;
    const toggleOpenOnDesktop = () => {
      setisSideNavOpenOnDesktop(!isSideNavOpenOnDesktop);
      // Have to store it as the opposite of the default we want
      localStorage.setItem(SOLUTION_NAV_COLLAPSED_KEY, JSON.stringify(isSideNavOpenOnDesktop));
    };
    const sideBarClasses = (0, _classnames.default)('kbnPageTemplate__pageSideBar', {
      'kbnPageTemplate__pageSideBar--shrink': isMediumBreakpoint || isLargerBreakpoint && !isSideNavOpenOnDesktop
    }, (_props$pageSideBarPro = props.pageSideBarProps) === null || _props$pageSideBarPro === void 0 ? void 0 : _props$pageSideBarPro.className);
    const templateToUse = isEmptyState && !template ? 'centeredContent' : template;
    const pageSideBar = /*#__PURE__*/_react.default.createElement(_solution_nav.KibanaPageTemplateSolutionNav, (0, _extends2.default)({
      isOpenOnDesktop: isSideNavOpenOnDesktop,
      onCollapse: toggleOpenOnDesktop
    }, solutionNav));
    const pageSideBarProps = {
      paddingSize: 'none',
      ...props.pageSideBarProps,
      className: sideBarClasses
    }; // needed because for some reason 'none' is not recognized as a valid value for paddingSize
    return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, propagatedProps, {
      pageSideBar: pageSideBar,
      pageSideBarProps: pageSideBarProps,
      template: templateToUse
    }), children);
  };
  WithSolutionNav.displayName = `WithSolutionNavBar(${getDisplayName(WrappedComponent)})`;
  return WithSolutionNav;
};
exports.withSolutionNav = withSolutionNav;