"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./page_template.scss");
var _react = _interopRequireDefault(require("react"));
var _no_data_page = require("./no_data_page");
var _page_template_inner = require("./page_template_inner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @deprecated Use `KibanaPageTemplate` from `@kbn/shared-ux-page-kibana-template`. */
const KibanaPageTemplate = ({
  template,
  className,
  children,
  solutionNav,
  noDataConfig,
  ...rest
}) => {
  /**
   * If passing the custom template of `noDataConfig`
   */
  if (noDataConfig && solutionNav) {
    return /*#__PURE__*/_react.default.createElement(_no_data_page.NoDataConfigPageWithSolutionNavBar, {
      "data-test-subj": rest['data-test-subj'],
      className: className,
      noDataConfig: noDataConfig,
      solutionNav: solutionNav
    });
  }
  if (noDataConfig) {
    return /*#__PURE__*/_react.default.createElement(_no_data_page.NoDataConfigPage, {
      "data-test-subj": rest['data-test-subj'],
      className: className,
      noDataConfig: noDataConfig
    });
  }
  if (solutionNav) {
    return /*#__PURE__*/_react.default.createElement(_page_template_inner.KibanaPageTemplateWithSolutionNav, (0, _extends2.default)({
      template: template,
      className: className,
      solutionNav: solutionNav,
      children: children
    }, rest));
  }
  return /*#__PURE__*/_react.default.createElement(_page_template_inner.KibanaPageTemplateInner, (0, _extends2.default)({
    template: template,
    className: className,
    children: children
  }, rest));
};
exports.KibanaPageTemplate = KibanaPageTemplate;