"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReactOverlays = void 0;
var React = _interopRequireWildcard(require("react"));
var _util = require("../util");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createReactOverlays = services => {
  const checkCoreService = () => {
    if (!services.overlays) {
      throw new TypeError('Could not show overlay as overlays service is not available.');
    }
  };
  const openFlyout = (node, options) => {
    var _services$theme;
    checkCoreService();
    return services.overlays.openFlyout((0, _util.toMountPoint)( /*#__PURE__*/React.createElement(React.Fragment, null, node), {
      theme$: (_services$theme = services.theme) === null || _services$theme === void 0 ? void 0 : _services$theme.theme$
    }), options);
  };
  const openModal = (node, options) => {
    var _services$theme2;
    checkCoreService();
    return services.overlays.openModal((0, _util.toMountPoint)( /*#__PURE__*/React.createElement(React.Fragment, null, node), {
      theme$: (_services$theme2 = services.theme) === null || _services$theme2 === void 0 ? void 0 : _services$theme2.theme$
    }), options);
  };
  const overlays = {
    openFlyout,
    openModal
  };
  return overlays;
};
exports.createReactOverlays = createReactOverlays;