"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNotifications = void 0;
var React = _interopRequireWildcard(require("react"));
var _util = require("../util");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createNotifications = services => {
  const show = ({
    title,
    body,
    color,
    iconType,
    toastLifeTimeMs,
    onClose
  }) => {
    var _services$theme, _services$theme2;
    if (!services.notifications) {
      throw new TypeError('Could not show notification as notifications service is not available.');
    }
    services.notifications.toasts.add({
      title: (0, _util.toMountPoint)(title, {
        theme$: (_services$theme = services.theme) === null || _services$theme === void 0 ? void 0 : _services$theme.theme$
      }),
      text: (0, _util.toMountPoint)( /*#__PURE__*/React.createElement(React.Fragment, null, body || null), {
        theme$: (_services$theme2 = services.theme) === null || _services$theme2 === void 0 ? void 0 : _services$theme2.theme$
      }),
      color,
      iconType,
      toastLifeTimeMs,
      onClose
    });
  };
  const success = input => show({
    color: 'success',
    iconType: 'check',
    ...input
  });
  const warning = input => show({
    color: 'warning',
    iconType: 'help',
    ...input
  });
  const danger = input => show({
    color: 'danger',
    iconType: 'error',
    ...input
  });
  const notifications = {
    toasts: {
      show,
      success,
      warning,
      danger
    }
  };
  return notifications;
};
exports.createNotifications = createNotifications;