"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/newsfeed-plugin/public");
var _app = require("./components/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const renderApp = (core, deps, {
  appBasePath,
  element,
  theme$
}) => {
  const {
    notifications,
    http
  } = core;
  const {
    newsfeed,
    home,
    navigation
  } = deps;
  const newsfeed$ = newsfeed === null || newsfeed === void 0 ? void 0 : newsfeed.createNewsFeed$(_public2.NewsfeedApiEndpoint.KIBANA_ANALYTICS);
  const features = home.featureCatalogue.get();
  core.chrome.setBreadcrumbs([{
    text: _i18n.i18n.translate('kibanaOverview.breadcrumbs.title', {
      defaultMessage: 'Analytics'
    })
  }]);
  core.chrome.navLinks.getNavLinks$().subscribe(navLinks => {
    const solutions = home.featureCatalogue.getSolutions().filter(({
      id
    }) => id !== 'kibana').filter(({
      id
    }) => navLinks.find(({
      category,
      hidden
    }) => !hidden && (category === null || category === void 0 ? void 0 : category.id) === id));
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...core,
        ...deps
      }
    }, /*#__PURE__*/_react.default.createElement(_app.KibanaOverviewApp, {
      basename: appBasePath,
      notifications,
      http,
      navigation,
      newsfeed$,
      solutions,
      features
    })))), element);
  });
  return () => _reactDom.default.unmountComponentAtNode(element);
};
exports.renderApp = renderApp;