"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strictKeysRt = strictKeysRt;
var t = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/lib/Either");
var _lodash = require("lodash");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const tags = ['DictionaryType', 'IntersectionType', 'MergeType', 'InterfaceType', 'PartialType', 'ExactType', 'UnionType'];
function isParsableType(type) {
  return tags.includes(type._tag);
}
function getHandlingTypes(type, key, value) {
  if (!isParsableType(type)) {
    return [];
  }
  switch (type._tag) {
    case 'DictionaryType':
      return [type.codomain];
    case 'IntersectionType':
      return type.types.map(i => getHandlingTypes(i, key, value)).flat();
    case 'MergeType':
      return type.types.map(i => getHandlingTypes(i, key, value)).flat();
    case 'InterfaceType':
    case 'PartialType':
      return [type.props[key]];
    case 'ExactType':
      return getHandlingTypes(type.type, key, value);
    case 'UnionType':
      const matched = type.types.find(m => (0, _Either.isRight)(m.decode(value)));
      return matched ? getHandlingTypes(matched, key, value) : [];
  }
}
function getHandledKeys(type, object, prefix = '') {
  const keys = {
    handled: new Set(),
    all: new Set()
  };
  (0, _lodash.forEach)(object, (value, key) => {
    const ownPrefix = prefix ? `${prefix}.${key}` : key;
    keys.all.add(ownPrefix);
    const handlingTypes = getHandlingTypes(type, key, object).filter(Boolean);
    if (handlingTypes.length) {
      keys.handled.add(ownPrefix);
    }
    if ((0, _lodash.isPlainObject)(value)) {
      handlingTypes.forEach(i => {
        const nextKeys = getHandledKeys(i, value, ownPrefix);
        nextKeys.all.forEach(k => keys.all.add(k));
        nextKeys.handled.forEach(k => keys.handled.add(k));
      });
    }
  });
  return keys;
}
function strictKeysRt(type) {
  return new t.Type(type.name, type.is, (input, context) => {
    return _Either.either.chain(type.validate(input, context), i => {
      const keys = getHandledKeys(type, input);
      const excessKeys = (0, _lodash.difference)([...keys.all], [...keys.handled]);
      if (excessKeys.length) {
        return t.failure(i, context, `Excess keys are not allowed:\n${excessKeys.join('\n')}`);
      }
      return t.success(i);
    });
  }, type.encode);
}