"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class FilterManager {
  constructor(controlId, fieldName, indexPatternId, indexPatternsService, queryFilter) {
    (0, _defineProperty2.default)(this, "indexPattern", void 0);
    this.controlId = controlId;
    this.fieldName = fieldName;
    this.indexPatternId = indexPatternId;
    this.indexPatternsService = indexPatternsService;
    this.queryFilter = queryFilter;
  }

  /**
   * Convert phrases into filter
   *
   * @param  {any[]} phrases
   * @returns PhraseFilter
   *   single phrase: match query
   *   multiple phrases: bool query with should containing list of match_phrase queries
   */

  async init() {
    try {
      if (!this.indexPattern) {
        this.indexPattern = await this.indexPatternsService.get(this.indexPatternId);
      }
    } catch (e) {
      // invalid index pattern id
    }
  }
  getIndexPattern() {
    return this.indexPattern;
  }
  getField() {
    var _this$indexPattern;
    return (_this$indexPattern = this.indexPattern) === null || _this$indexPattern === void 0 ? void 0 : _this$indexPattern.fields.getByName(this.fieldName);
  }
  findFilters() {
    const kbnFilters = _lodash.default.flatten([this.queryFilter.getAppFilters(), this.queryFilter.getGlobalFilters()]);
    return kbnFilters.filter(kbnFilter => {
      return _lodash.default.get(kbnFilter, 'meta.controlledBy') === this.controlId;
    });
  }
}
exports.FilterManager = FilterManager;