"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineDetailsJsonBlock = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineDetailsJsonBlock = ({
  json
}) => {
  // Hack so copied-to-clipboard value updates as content changes
  // Related issue: https://github.com/elastic/eui/issues/3321
  const uuid = (0, _react.useRef)(0);
  uuid.current++;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "s",
    language: "json",
    overflowHeight: json.length > 0 ? 300 : undefined,
    isCopyable: true,
    key: uuid.current
  }, JSON.stringify(json, null, 2));
};
exports.PipelineDetailsJsonBlock = PipelineDetailsJsonBlock;