"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _monaco = require("@kbn/monaco");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelinesPreview = ({
  processors,
  onDownload,
  onClickToCreatePipeline,
  onUpdateProcessors,
  hasError
}) => {
  const [isValidJson, setIsValidJson] = (0, _react.useState)(true);
  const [processorsJson, setProcessorsJson] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const jsonString = JSON.stringify(processors, null, 2);
    setProcessorsJson(jsonString);
  }, [processors]);
  const onUpdate = updated => {
    setProcessorsJson(updated);
    try {
      setIsValidJson(true);
      const parsedJson = JSON.parse(updated);
      onUpdateProcessors(parsedJson);
    } catch (e) {
      setIsValidJson(false);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !hasError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Processor definitions generated",
    color: "success",
    iconType: "check"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.createFromCsv.preview.jsonMapSuccessful",
    defaultMessage: "You can save or edit the JSON before generating the pipeline."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !isValidJson,
    error: !isValidJson ? _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.preview.invalidJson', {
      defaultMessage: 'Invalid JSON.'
    }) : null,
    fullWidth: true,
    "data-test-subj": "pipelineMappingsJSONEditor"
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.CodeEditorField, {
    "aria-label": '',
    languageId: _monaco.XJsonLang.ID,
    value: processorsJson,
    onChange: onUpdate,
    fullWidth: true,
    height: "400px",
    options: {
      accessibilitySupport: 'off',
      lineNumbers: 'on',
      fontSize: 12,
      tabSize: 2,
      automaticLayout: true,
      minimap: {
        enabled: false
      },
      overviewRulerBorder: false,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent'
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onClickToCreatePipeline,
    "data-test-subj": "continueToCreate"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.createFromCsv.preview.createPipeline",
    defaultMessage: "Continue to create pipeline"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: processorsJson
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "copy",
    size: "s",
    onClick: copy,
    "data-test-subj": "copyToClipboard"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.createFromCsv.preview.copy",
    defaultMessage: "Copy JSON"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "download",
    size: "s",
    onClick: onDownload,
    "data-test-subj": "downloadJson"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.createFromCsv.preview.download",
    defaultMessage: "Download JSON"
  }))))));
};
exports.PipelinesPreview = PipelinesPreview;