"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.from = exports.arrayOfStrings = exports.EDITOR_PX_HEIGHT = void 0;
exports.isArrayOfStrings = isArrayOfStrings;
exports.to = exports.isJSONStringValidator = exports.isEmptyString = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _i18n = require("@kbn/i18n");
var _Either = require("fp-ts/lib/Either");
var _shared_imports = require("../../../../../../shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const arrayOfStrings = rt.array(rt.string);
exports.arrayOfStrings = arrayOfStrings;
function isArrayOfStrings(v) {
  const res = arrayOfStrings.decode(v);
  return (0, _Either.isRight)(res);
}

/**
 * Shared deserializer functions.
 *
 * These are intended to be used in @link{FieldsConfig} as the "deserializer".
 *
 * Example:
 * {
 *   ...
 *   deserialize: to.booleanOrUndef,
 *   ...
 * }
 *
 */
const to = {
  booleanOrUndef: v => typeof v === 'boolean' ? v : undefined,
  arrayOfStrings: v => isArrayOfStrings(v) ? v : typeof v === 'string' && v.length ? [v] : [],
  jsonString: v => v ? JSON.stringify(v, null, 2) : '{}',
  /**
   * Useful when deserializing strings that will be rendered inside of text areas or text inputs. We want
   * a string like: "my\ttab" to render the same, not to render as "my<tab>tab".
   */
  escapeBackslashes: v => {
    if (typeof v === 'string') {
      const s = JSON.stringify(v);
      return s.slice(1, s.length - 1);
    }
    return v;
  }
};

/**
 * Shared serializer functions.
 *
 * These are intended to be used in @link{FieldsConfig} as the "serializer".
 *
 * Example:
 * {
 *   ...
 *   serializer: from.optionalJson,
 *   ...
 * }
 *
 */
exports.to = to;
const from = {
  /* Works with `to.jsonString` as deserializer. */
  optionalJson: v => {
    if (v) {
      try {
        const json = JSON.parse(v);
        if (Object.keys(json).length) {
          return json;
        }
      } catch (e) {
        // Ignore
      }
    }
    return undefined;
  },
  optionalArrayOfStrings: v => v.length ? v : undefined,
  undefinedIfValue: value => v => v === value ? undefined : v,
  emptyStringToUndefined: v => v === '' ? undefined : v,
  /**
   * Useful when serializing user input from a <textarea /> that we want to later JSON.stringify but keep the same as what
   * the user input. For instance, given "my\ttab", encoded as "my%5Ctab" will JSON.stringify to "my\\ttab", instead we want
   * to keep the input exactly as the user entered it.
   */
  unescapeBackslashes: v => {
    if (typeof v === 'string') {
      try {
        return JSON.parse(`"${v}"`);
      } catch (e) {
        // Best effort
        return v;
      }
    }
  }
};
exports.from = from;
const isJSONString = v => {
  try {
    JSON.parse(`"${v}"`);
    return true;
  } catch (e) {
    return false;
  }
};
const isJSONStringValidator = ({
  value
}) => {
  if (typeof value !== 'string' || !isJSONString(value)) {
    return {
      message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.jsonStringField.invalidStringMessage', {
        defaultMessage: 'Invalid JSON string.'
      })
    };
  }
};

/**
 * Similar to the emptyField validator but we accept whitespace characters.
 */
exports.isJSONStringValidator = isJSONStringValidator;
const isEmptyString = message => field => {
  const {
    value
  } = field;
  if (typeof value === 'string') {
    const hasLength = Boolean(value.length);
    const hasNonWhiteSpaceChars = hasLength && Boolean(value.trim().length);
    if (hasNonWhiteSpaceChars) {
      return emptyField(message)(field);
    }
  }
};
exports.isEmptyString = isEmptyString;
const EDITOR_PX_HEIGHT = {
  extraSmall: 75,
  small: 100,
  medium: 200,
  large: 300
};
exports.EDITOR_PX_HEIGHT = EDITOR_PX_HEIGHT;