"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommonProcessorFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _shared_imports = require("../../../../../../../shared_imports");
var _field_components = require("../../field_components");
var _shared = require("../shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ignoreFailureConfig = {
  defaultValue: false,
  deserializer: _shared.to.booleanOrUndef,
  serializer: _shared.from.undefinedIfValue(false),
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.ignoreFailureFieldLabel', {
    defaultMessage: 'Ignore failure'
  }),
  helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.ignoreFailureHelpText', {
    defaultMessage: 'Ignore failures for this processor.'
  }),
  type: _shared_imports.FIELD_TYPES.TOGGLE
};
const ifConfig = {
  serializer: _shared.from.emptyStringToUndefined,
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.ifFieldLabel', {
    defaultMessage: 'Condition (optional)'
  }),
  helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.ifFieldHelpText', {
    defaultMessage: 'Conditionally run this processor.'
  }),
  type: _shared_imports.FIELD_TYPES.TEXT
};
const tagConfig = {
  serializer: _shared.from.emptyStringToUndefined,
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.tagFieldLabel', {
    defaultMessage: 'Tag (optional)'
  }),
  helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.tagFieldHelpText', {
    defaultMessage: 'Identifier for the processor. Useful for debugging and metrics.'
  }),
  type: _shared_imports.FIELD_TYPES.TEXT
};
const CommonProcessorFields = () => {
  const suggestionProvider = _monaco.PainlessLang.getSuggestionProvider('processor_conditional');
  return /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "ifField",
    config: ifConfig,
    component: _field_components.TextEditor,
    componentProps: {
      editorProps: {
        languageId: _monaco.PainlessLang.ID,
        suggestionProvider,
        height: _shared.EDITOR_PX_HEIGHT.extraSmall,
        options: {
          lineNumbers: 'off',
          minimap: {
            enabled: false
          }
        }
      }
    },
    path: "fields.if"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "tagField",
    config: tagConfig,
    component: _shared_imports.Field,
    path: "fields.tag"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "ignoreFailureSwitch",
    config: ignoreFailureConfig,
    component: _shared_imports.ToggleField,
    path: "fields.ignore_failure"
  }));
};
exports.CommonProcessorFields = CommonProcessorFields;