"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineProcessorsItemTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
require("./pipeline_processors_editor_item_toolip.scss");
var _processor_information = require("./processor_information");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MOUSE_PADDING_RIGHT = 20;
const MOUSE_PADDING_BOTTOM = 20;
const PipelineProcessorsItemTooltip = ({
  processor
}) => {
  const [position, setPosition] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const mouseMoveListener = event => {
      setPosition({
        x: event.pageX,
        y: event.pageY - window.scrollY
      });
    };
    document.addEventListener('mousemove', mouseMoveListener);
    return () => {
      document.removeEventListener('mousemove', mouseMoveListener);
    };
  }, []);
  if (!position) {
    return null;
  }
  return (
    /*#__PURE__*/
    /**
     * To get around issues with parent elements potentially being position: relative or
     * overflow: hidden we use a portal to render this tooltip in the document body so
     * that we can render it anywhere the cursor can go.
     */
    _react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "pipelineProcessorsEditor__itemTooltip",
      style: {
        left: position.x + MOUSE_PADDING_RIGHT,
        top: position.y + MOUSE_PADDING_BOTTOM
      }
    }, /*#__PURE__*/_react.default.createElement(_processor_information.ProcessorInformation, {
      processor: processor
    })))
  );
};
exports.PipelineProcessorsItemTooltip = PipelineProcessorsItemTooltip;