"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initDeleteInventoryViewRoute = void 0;
var _boom = require("@hapi/boom");
var _runtime_types = require("../../../common/runtime_types");
var _latest = require("../../../common/http_api/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initDeleteInventoryViewRoute = ({
  framework,
  getStartServices
}) => {
  framework.registerRoute({
    method: 'delete',
    path: _latest.INVENTORY_VIEW_URL_ENTITY,
    validate: {
      params: (0, _runtime_types.createValidationFunction)(_latest.inventoryViewRequestParamsRT)
    }
  }, async (_requestContext, request, response) => {
    const {
      params
    } = request;
    const [,, {
      inventoryViews
    }] = await getStartServices();
    const inventoryViewsClient = inventoryViews.getScopedClient(request);
    try {
      await inventoryViewsClient.delete(params.inventoryViewId);
      return response.noContent();
    } catch (error) {
      var _error$statusCode, _error$message;
      if ((0, _boom.isBoom)(error)) {
        return response.customError({
          statusCode: error.output.statusCode,
          body: {
            message: error.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initDeleteInventoryViewRoute = initDeleteInventoryViewRoute;