"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHosts = void 0;
var _get_filtered_hosts = require("./get_filtered_hosts");
var _mapper = require("../mapper");
var _utils = require("../utils");
var _get_all_hosts = require("./get_all_hosts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHosts = async args => {
  const runFilterQuery = (0, _utils.hasFilters)(args.params.query);
  // filter first to prevent filter clauses from impacting the metrics aggregations.
  const hostNamesShortList = runFilterQuery ? await getFilteredHostNames(args) : [];
  if (runFilterQuery && hostNamesShortList.length === 0) {
    return {
      type: 'host',
      nodes: []
    };
  }
  const result = await (0, _get_all_hosts.getAllHosts)(args, hostNamesShortList);
  return (0, _mapper.mapToApiResponse)(args.params, result === null || result === void 0 ? void 0 : result.nodes.buckets);
};
exports.getHosts = getHosts;
const getFilteredHostNames = async args => {
  var _nodes$buckets$map;
  const filteredHosts = await (0, _get_filtered_hosts.getFilteredHosts)(args);
  const {
    nodes
  } = filteredHosts !== null && filteredHosts !== void 0 ? filteredHosts : {};
  return (_nodes$buckets$map = nodes === null || nodes === void 0 ? void 0 : nodes.buckets.map(p => p.key)) !== null && _nodes$buckets$map !== void 0 ? _nodes$buckets$map : [];
};