"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomMetricsAggregations = void 0;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isMetricExpressionCustomMetric = subject => {
  return subject.aggType != null;
};
const createCustomMetricsAggregations = (id, customMetrics, equation) => {
  const bucketsPath = {};
  const metricAggregations = customMetrics.reduce((acc, metric) => {
    const key = `${id}_${metric.name}`;
    const aggregation = isMetricExpressionCustomMetric(metric) ? metric.aggType : metric.aggregation;
    if (aggregation === 'count') {
      bucketsPath[metric.name] = `${key}>_count`;
      return {
        ...acc,
        [key]: {
          filter: metric.filter ? (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(metric.filter)) : {
            match_all: {}
          }
        }
      };
    }
    if (aggregation && metric.field) {
      bucketsPath[metric.name] = key;
      return {
        ...acc,
        [key]: {
          [aggregation]: {
            field: metric.field
          }
        }
      };
    }
    return acc;
  }, {});
  if ((0, _lodash.isEmpty)(metricAggregations)) {
    return {};
  }
  return {
    ...metricAggregations,
    [id]: {
      bucket_script: {
        buckets_path: bucketsPath,
        script: {
          source: convertEquationToPainless(bucketsPath, equation),
          lang: 'painless'
        }
      }
    }
  };
};
exports.createCustomMetricsAggregations = createCustomMetricsAggregations;
const convertEquationToPainless = (bucketsPath, equation) => {
  const workingEquation = equation || Object.keys(bucketsPath).join(' + ');
  return Object.keys(bucketsPath).reduce((acc, key) => {
    return acc.replace(key, `params.${key}`);
  }, workingEquation);
};