"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseInterval = exports.convertIntervalToString = exports.INTERVAL_STRING_RE = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTERVAL_STRING_RE = new RegExp(`^([\\d\\.]+)\\s*(${_datemath.default.units.join('|')})$`);
exports.INTERVAL_STRING_RE = INTERVAL_STRING_RE;
const parseInterval = intervalString => {
  if (intervalString) {
    const matches = intervalString.match(INTERVAL_STRING_RE);
    if (matches) {
      const value = Number(matches[1]);
      const unit = matches[2];
      return {
        value,
        unit
      };
    }
  }
  throw new Error(_i18n.i18n.translate('xpack.infra.parseInterval.errorMessage', {
    defaultMessage: '{value} is not an interval string',
    values: {
      value: intervalString
    }
  }));
};
exports.parseInterval = parseInterval;
const ValidUnitRT = rt.keyof({
  seconds: null,
  minutes: null,
  hours: null,
  days: null,
  weeks: null,
  months: null,
  years: null
});
const UNITS = ['seconds', 'minutes', 'hours', 'days', 'weeks', 'months', 'years'];
const DISPLAY_STRINGS_FOR_UNITS_PLURAL = {
  seconds: _i18n.i18n.translate('xpack.infra.durationUnits.seconds.plural', {
    defaultMessage: 'seconds'
  }),
  minutes: _i18n.i18n.translate('xpack.infra.durationUnits.minutes.plural', {
    defaultMessage: 'minutes'
  }),
  hours: _i18n.i18n.translate('xpack.infra.durationUnits.hours.plural', {
    defaultMessage: 'hours'
  }),
  days: _i18n.i18n.translate('xpack.infra.durationUnits.days.plural', {
    defaultMessage: 'days'
  }),
  weeks: _i18n.i18n.translate('xpack.infra.durationUnits.weeks.plural', {
    defaultMessage: 'weeks'
  }),
  months: _i18n.i18n.translate('xpack.infra.durationUnits.months.plural', {
    defaultMessage: 'months'
  }),
  years: _i18n.i18n.translate('xpack.infra.durationUnits.years.plural', {
    defaultMessage: 'years'
  })
};
const DISPLAY_STRINGS_FOR_UNITS_SINGULAR = {
  seconds: _i18n.i18n.translate('xpack.infra.durationUnits.seconds.singular', {
    defaultMessage: 'second'
  }),
  minutes: _i18n.i18n.translate('xpack.infra.durationUnits.minutes.singular', {
    defaultMessage: 'minute'
  }),
  hours: _i18n.i18n.translate('xpack.infra.durationUnits.hours.singular', {
    defaultMessage: 'hour'
  }),
  days: _i18n.i18n.translate('xpack.infra.durationUnits.days.singular', {
    defaultMessage: 'day'
  }),
  weeks: _i18n.i18n.translate('xpack.infra.durationUnits.weeks.singular', {
    defaultMessage: 'week'
  }),
  months: _i18n.i18n.translate('xpack.infra.durationUnits.months.singular', {
    defaultMessage: 'month'
  }),
  years: _i18n.i18n.translate('xpack.infra.durationUnits.years.singular', {
    defaultMessage: 'year'
  })
};
const getDisplayableUnit = (value, unit) => {
  return Math.floor(value) === 1 ? DISPLAY_STRINGS_FOR_UNITS_SINGULAR[unit] : DISPLAY_STRINGS_FOR_UNITS_PLURAL[unit];
};
const convertIntervalToString = input => {
  const interval = parseInterval(input);
  if ((interval === null || interval === void 0 ? void 0 : interval.unit) === 's') {
    const duration = _moment.default.duration(interval.value, interval.unit);
    const targetUnit = UNITS.reduce((answer, unit) => {
      if (duration.as(unit) >= 1) {
        return unit;
      }
      return answer;
    }, 'seconds');
    const durationAsUnit = duration.as(targetUnit);
    return `${Math.floor(durationAsUnit)} ${getDisplayableUnit(durationAsUnit, targetUnit)}`;
  }
};
exports.convertIntervalToString = convertIntervalToString;