"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Client which aggregate all the available telemetry tracking functions
 * for the Infra plugin
 */
class TelemetryClient {
  constructor(analytics) {
    (0, _defineProperty2.default)(this, "reportHostEntryClicked", ({
      hostname,
      cloud_provider: cloudProvider
    }) => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOSTS_ENTRY_CLICKED, {
        hostname,
        cloud_provider: cloudProvider !== null && cloudProvider !== void 0 ? cloudProvider : 'unknown'
      });
    });
    (0, _defineProperty2.default)(this, "reportHostFlyoutFilterRemoved", ({
      field_name: fieldName
    }) => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOST_FLYOUT_FILTER_REMOVED, {
        field_name: fieldName
      });
    });
    (0, _defineProperty2.default)(this, "reportHostFlyoutFilterAdded", ({
      field_name: fieldName
    }) => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOST_FLYOUT_FILTER_ADDED, {
        field_name: fieldName
      });
    });
    (0, _defineProperty2.default)(this, "reportHostsViewQuerySubmitted", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOSTS_VIEW_QUERY_SUBMITTED, params);
    });
    this.analytics = analytics;
  }
  reportHostsViewTotalHostCountRetrieved(params) {
    this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOST_VIEW_TOTAL_HOST_COUNT_RETRIEVED, params);
  }
}
exports.TelemetryClient = TelemetryClient;