"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _constants = require("../common/constants");
var _log_views = require("../common/log_views");
var _inventory = require("./alerting/inventory");
var _log_threshold = require("./alerting/log_threshold");
var _metric_threshold = require("./alerting/metric_threshold");
var _create_lazy_container_metrics_table = require("./components/infrastructure_node_metrics_tables/container/create_lazy_container_metrics_table");
var _create_lazy_host_metrics_table = require("./components/infrastructure_node_metrics_tables/host/create_lazy_host_metrics_table");
var _create_lazy_pod_metrics_table = require("./components/infrastructure_node_metrics_tables/pod/create_lazy_pod_metrics_table");
var _log_stream_embeddable = require("./components/log_stream/log_stream_embeddable");
var _log_stream_embeddable_factory = require("./components/log_stream/log_stream_embeddable_factory");
var _locators = require("../common/locators");
var _metrics_overview_fetchers = require("./metrics_overview_fetchers");
var _register_feature = require("./register_feature");
var _inventory_views = require("./services/inventory_views");
var _log_views2 = require("./services/log_views");
var _metrics_explorer_views = require("./services/metrics_explorer_views");
var _telemetry = require("./services/telemetry");
var _logs_overview_fetchers = require("./utils/logs_overview_fetchers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class Plugin {
  constructor(context) {
    var _this$config$sources$, _this$config$sources, _this$config$sources$2, _this$config$sources$3;
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "inventoryViews", void 0);
    (0, _defineProperty2.default)(this, "logViews", void 0);
    (0, _defineProperty2.default)(this, "metricsExplorerViews", void 0);
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "locators", void 0);
    (0, _defineProperty2.default)(this, "appTarget", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    this.config = context.config.get();
    this.inventoryViews = new _inventory_views.InventoryViewsService();
    this.logViews = new _log_views2.LogViewsService({
      messageFields: (_this$config$sources$ = (_this$config$sources = this.config.sources) === null || _this$config$sources === void 0 ? void 0 : (_this$config$sources$2 = _this$config$sources.default) === null || _this$config$sources$2 === void 0 ? void 0 : (_this$config$sources$3 = _this$config$sources$2.fields) === null || _this$config$sources$3 === void 0 ? void 0 : _this$config$sources$3.message) !== null && _this$config$sources$ !== void 0 ? _this$config$sources$ : _log_views.defaultLogViewsStaticConfig.messageFields
    });
    this.metricsExplorerViews = new _metrics_explorer_views.MetricsExplorerViewsService();
    this.telemetry = new _telemetry.TelemetryService();
    this.appTarget = this.config.logs.app_target;
    this.kibanaVersion = context.env.packageInfo.version;
  }
  setup(core, pluginsSetup) {
    if (pluginsSetup.home) {
      (0, _register_feature.registerFeatures)(pluginsSetup.home);
    }
    pluginsSetup.uiActions.registerTrigger({
      id: _common.ObservabilityTriggerId.LogEntryContextMenu
    });
    pluginsSetup.observability.observabilityRuleTypeRegistry.register((0, _inventory.createInventoryMetricRuleType)());
    pluginsSetup.observability.observabilityRuleTypeRegistry.register((0, _metric_threshold.createMetricThresholdRuleType)());
    pluginsSetup.observability.dashboard.register({
      appName: 'infra_logs',
      hasData: (0, _logs_overview_fetchers.getLogsHasDataFetcher)(core.getStartServices),
      fetchData: (0, _logs_overview_fetchers.getLogsOverviewDataFetcher)(core.getStartServices)
    });
    pluginsSetup.observability.dashboard.register({
      appName: 'infra_metrics',
      hasData: (0, _metrics_overview_fetchers.createMetricsHasData)(core.getStartServices),
      fetchData: (0, _metrics_overview_fetchers.createMetricsFetchData)(core.getStartServices)
    });
    const startDep$AndHostViewFlag$ = (0, _rxjs.combineLatest)([(0, _rxjs.from)(core.getStartServices()), core.uiSettings.get$(_public2.enableInfrastructureHostsView)]);

    /** !! Need to be kept in sync with the deepLinks in x-pack/plugins/infra/public/plugin.ts */
    const infraEntries = [{
      label: 'Inventory',
      app: 'metrics',
      path: '/inventory'
    }, {
      label: 'Metrics Explorer',
      app: 'metrics',
      path: '/explorer'
    }, {
      label: 'Hosts',
      isBetaFeature: true,
      app: 'metrics',
      path: '/hosts'
    }];
    pluginsSetup.observabilityShared.navigation.registerSections(startDep$AndHostViewFlag$.pipe((0, _operators.map)(([[{
      application: {
        capabilities
      }
    }]]) => [...(capabilities.logs.show ? [{
      label: 'Logs',
      sortKey: 200,
      entries: [{
        label: 'Stream',
        app: 'logs',
        path: '/stream'
      }, {
        label: 'Anomalies',
        app: 'logs',
        path: '/anomalies'
      }, {
        label: 'Categories',
        app: 'logs',
        path: '/log-categories'
      }]
    }] : []), ...(capabilities.infrastructure.show ? [{
      label: 'Infrastructure',
      sortKey: 300,
      entries: infraEntries
    }] : [])])));
    pluginsSetup.embeddable.registerEmbeddableFactory(_log_stream_embeddable.LOG_STREAM_EMBEDDABLE, new _log_stream_embeddable_factory.LogStreamEmbeddableFactoryDefinition(core.getStartServices));

    // Register Locators
    let logsLocator = pluginsSetup.share.url.locators.create(new _locators.LogsLocatorDefinition({
      core
    }));
    let nodeLogsLocator = pluginsSetup.share.url.locators.create(new _locators.NodeLogsLocatorDefinition({
      core
    }));
    if (this.appTarget === _constants.DISCOVER_APP_TARGET) {
      // Register Locators
      logsLocator = pluginsSetup.share.url.locators.create(new _locators.DiscoverLogsLocatorDefinition({
        core
      }));
      nodeLogsLocator = pluginsSetup.share.url.locators.create(new _locators.DiscoverNodeLogsLocatorDefinition({
        core
      }));
      core.application.register({
        id: 'logs-to-discover',
        title: '',
        navLinkStatus: _public.AppNavLinkStatus.hidden,
        appRoute: '/app/logs',
        mount: async params => {
          // mount callback should not use setup dependencies, get start dependencies instead
          const [coreStart,, pluginStart] = await core.getStartServices();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/discover_app')));
          return renderApp(coreStart, pluginStart, params);
        }
      });
    }
    pluginsSetup.observability.observabilityRuleTypeRegistry.register((0, _log_threshold.createLogThresholdRuleType)(core, logsLocator));
    if (this.appTarget === _constants.LOGS_APP_TARGET) {
      core.application.register({
        id: 'logs',
        title: _i18n.i18n.translate('xpack.infra.logs.pluginTitle', {
          defaultMessage: 'Logs'
        }),
        euiIconType: 'logoObservability',
        order: 8100,
        appRoute: '/app/logs',
        // !! Need to be kept in sync with the routes in x-pack/plugins/infra/public/pages/logs/page_content.tsx
        deepLinks: [{
          id: 'stream',
          title: _i18n.i18n.translate('xpack.infra.logs.index.streamTabTitle', {
            defaultMessage: 'Stream'
          }),
          path: '/stream'
        }, {
          id: 'anomalies',
          title: _i18n.i18n.translate('xpack.infra.logs.index.anomaliesTabTitle', {
            defaultMessage: 'Anomalies'
          }),
          path: '/anomalies'
        }, {
          id: 'log-categories',
          title: _i18n.i18n.translate('xpack.infra.logs.index.logCategoriesBetaBadgeTitle', {
            defaultMessage: 'Categories'
          }),
          path: '/log-categories'
        }, {
          id: 'settings',
          title: _i18n.i18n.translate('xpack.infra.logs.index.settingsTabTitle', {
            defaultMessage: 'Settings'
          }),
          path: '/settings'
        }],
        category: _public.DEFAULT_APP_CATEGORIES.observability,
        mount: async params => {
          // mount callback should not use setup dependencies, get start dependencies instead
          const [coreStart, plugins, pluginStart] = await core.getStartServices();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/logs_app')));
          return renderApp(coreStart, plugins, pluginStart, params);
        }
      });
    }

    // !! Need to be kept in sync with the routes in x-pack/plugins/infra/public/pages/metrics/index.tsx
    const infraDeepLinks = [{
      id: 'inventory',
      title: _i18n.i18n.translate('xpack.infra.homePage.inventoryTabTitle', {
        defaultMessage: 'Inventory'
      }),
      path: '/inventory'
    }, {
      id: 'metrics-hosts',
      title: _i18n.i18n.translate('xpack.infra.homePage.metricsHostsTabTitle', {
        defaultMessage: 'Hosts'
      }),
      path: '/hosts'
    }, {
      id: 'metrics-explorer',
      title: _i18n.i18n.translate('xpack.infra.homePage.metricsExplorerTabTitle', {
        defaultMessage: 'Metrics Explorer'
      }),
      path: '/explorer'
    }, {
      id: 'settings',
      title: _i18n.i18n.translate('xpack.infra.homePage.settingsTabTitle', {
        defaultMessage: 'Settings'
      }),
      path: '/settings'
    }];
    core.application.register({
      id: 'metrics',
      title: _i18n.i18n.translate('xpack.infra.metrics.pluginTitle', {
        defaultMessage: 'Infrastructure'
      }),
      euiIconType: 'logoObservability',
      order: 8200,
      appRoute: '/app/metrics',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      updater$: this.appUpdater$,
      deepLinks: infraDeepLinks,
      mount: async params => {
        // mount callback should not use setup dependencies, get start dependencies instead
        const [coreStart, plugins, pluginStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/metrics_app')));
        return renderApp(coreStart, {
          ...plugins,
          kibanaVersion: this.kibanaVersion
        }, pluginStart, params);
      }
    });
    startDep$AndHostViewFlag$.subscribe(([_startServices]) => {
      this.appUpdater$.next(() => ({
        deepLinks: infraDeepLinks
      }));
    });

    /* This exists purely to facilitate URL redirects from the old App ID ("infra"),
    to our new App IDs ("metrics" and "logs"). With version 8.0.0 we can remove this. */
    core.application.register({
      id: 'infra',
      appRoute: '/app/infra',
      title: 'infra',
      navLinkStatus: 3,
      mount: async params => {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/legacy_app')));
        return renderApp(params);
      }
    });

    // Setup telemetry events
    this.telemetry.setup({
      analytics: core.analytics
    });
    this.locators = {
      logsLocator,
      nodeLogsLocator
    };
    return {
      locators: this.locators
    };
  }
  start(core, plugins) {
    const getStartServices = () => [core, plugins, startContract];
    const inventoryViews = this.inventoryViews.start({
      http: core.http
    });
    const logViews = this.logViews.start({
      http: core.http,
      dataViews: plugins.dataViews,
      search: plugins.data.search
    });
    const metricsExplorerViews = this.metricsExplorerViews.start({
      http: core.http
    });
    const telemetry = this.telemetry.start();
    const startContract = {
      inventoryViews,
      logViews,
      metricsExplorerViews,
      telemetry,
      locators: this.locators,
      ContainerMetricsTable: (0, _create_lazy_container_metrics_table.createLazyContainerMetricsTable)(getStartServices),
      HostMetricsTable: (0, _create_lazy_host_metrics_table.createLazyHostMetricsTable)(getStartServices),
      PodMetricsTable: (0, _create_lazy_pod_metrics_table.createLazyPodMetricsTable)(getStartServices)
    };
    return startContract;
  }
  stop() {}
}
exports.Plugin = Plugin;