"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaffleFiltersContext = exports.useWaffleFilters = exports.WaffleFiltersStateRT = exports.WaffleFiltersProvider = exports.WaffleFilters = exports.DEFAULT_WAFFLE_FILTERS_STATE = void 0;
var _esQuery = require("@kbn/es-query");
var _react = require("react");
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _constate = _interopRequireDefault(require("constate"));
var _use_alert_prefill = require("../../../../alerting/use_alert_prefill");
var _use_url_state = require("../../../../utils/use_url_state");
var _metrics_source = require("../../../../containers/metrics_source");
var _kuery = require("../../../../utils/kuery");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateKuery = expression => {
  try {
    (0, _esQuery.fromKueryExpression)(expression);
  } catch (err) {
    return false;
  }
  return true;
};
const DEFAULT_WAFFLE_FILTERS_STATE = {
  kind: 'kuery',
  expression: ''
};
exports.DEFAULT_WAFFLE_FILTERS_STATE = DEFAULT_WAFFLE_FILTERS_STATE;
const useWaffleFilters = () => {
  const {
    createDerivedIndexPattern
  } = (0, _metrics_source.useSourceContext)();
  const indexPattern = createDerivedIndexPattern();
  const [urlState, setUrlState] = (0, _use_url_state.useUrlState)({
    defaultState: DEFAULT_WAFFLE_FILTERS_STATE,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: 'waffleFilter'
  });
  const [state, setState] = (0, _react.useState)(urlState);
  (0, _react.useEffect)(() => setUrlState(state), [setUrlState, state]);
  const [filterQueryDraft, setFilterQueryDraft] = (0, _react.useState)(urlState.expression);
  const filterQueryAsJson = (0, _react.useMemo)(() => (0, _kuery.convertKueryToElasticSearchQuery)(urlState.expression, indexPattern), [indexPattern, urlState.expression]);
  const applyFilterQueryFromKueryExpression = (0, _react.useCallback)(expression => {
    setState(previous => ({
      ...previous,
      kind: 'kuery',
      expression
    }));
  }, [setState]);
  const applyFilterQuery = (0, _react.useCallback)(filterQuery => {
    setState(filterQuery);
    setFilterQueryDraft(filterQuery.expression);
  }, []);
  const isFilterQueryDraftValid = (0, _react.useMemo)(() => validateKuery(filterQueryDraft), [filterQueryDraft]);
  const {
    inventoryPrefill
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  const prefillContext = (0, _react.useMemo)(() => inventoryPrefill, [inventoryPrefill]); // For Jest compatibility
  (0, _react.useEffect)(() => prefillContext.setFilterQuery(state.expression), [prefillContext, state]);
  return {
    filterQuery: urlState,
    filterQueryDraft,
    filterQueryAsJson,
    applyFilterQuery,
    setFilterQueryDraftFromKueryExpression: setFilterQueryDraft,
    applyFilterQueryFromKueryExpression,
    isFilterQueryDraftValid,
    setWaffleFiltersState: applyFilterQuery
  };
};
exports.useWaffleFilters = useWaffleFilters;
const WaffleFiltersStateRT = rt.type({
  kind: rt.literal('kuery'),
  expression: rt.string
});
exports.WaffleFiltersStateRT = WaffleFiltersStateRT;
const encodeUrlState = WaffleFiltersStateRT.encode;
const decodeUrlState = value => (0, _pipeable.pipe)(WaffleFiltersStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
const WaffleFilters = (0, _constate.default)(useWaffleFilters);
exports.WaffleFilters = WaffleFilters;
const [WaffleFiltersProvider, useWaffleFiltersContext] = WaffleFilters;
exports.useWaffleFiltersContext = useWaffleFiltersContext;
exports.WaffleFiltersProvider = WaffleFiltersProvider;