"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionalToolTip = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _common = require("@kbn/kibana-react-plugin/common");
var _get_custom_metric_label = require("../../../../../../common/formatters/get_custom_metric_label");
var _metrics_source = require("../../../../../containers/metrics_source");
var _inventory_models = require("../../../../../../common/inventory_models");
var _types = require("../../../../../../common/inventory_models/types");
var _use_snaphot = require("../../hooks/use_snaphot");
var _create_inventory_metric_formatter = require("../../lib/create_inventory_metric_formatter");
var _intl_strings = require("../../../../../../common/inventory_models/intl_strings");
var _use_waffle_options = require("../../hooks/use_waffle_options");
var _create_formatter_for_metric = require("../../../metrics_explorer/components/helpers/create_formatter_for_metric");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConditionalToolTip = (0, _common.withTheme)(({
  theme,
  node,
  nodeType,
  currentTime
}) => {
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const model = (0, _inventory_models.findInventoryModel)(nodeType);
  const {
    customMetrics
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const requestMetrics = model.tooltipMetrics.map(type => ({
    type
  })).concat(customMetrics);
  const query = JSON.stringify({
    bool: {
      filter: {
        match_phrase: {
          [model.fields.id]: node.id
        }
      }
    }
  });
  const {
    nodes
  } = (0, _use_snaphot.useSnapshot)({
    filterQuery: query,
    metrics: requestMetrics,
    groupBy: [],
    nodeType,
    sourceId,
    currentTime,
    accountId: '',
    region: ''
  });
  const dataNode = (0, _lodash.first)(nodes);
  const metrics = dataNode && dataNode.metrics || [];
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: 200
    },
    "data-test-subj": `conditionalTooltipContent-${node.name}`
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      borderBottom: `1px solid ${theme === null || theme === void 0 ? void 0 : theme.eui.euiColorMediumShade}`,
      paddingBottom: theme === null || theme === void 0 ? void 0 : theme.eui.euiSizeXS,
      marginBottom: theme === null || theme === void 0 ? void 0 : theme.eui.euiSizeXS
    }
  }, node.name), metrics.map(metric => {
    const metricName = _types.SnapshotMetricTypeRT.is(metric.name) ? metric.name : 'custom';
    const name = _intl_strings.SNAPSHOT_METRIC_TRANSLATIONS[metricName] || metricName;
    // if custom metric, find field and label from waffleOptionsContext result
    // because useSnapshot does not return it
    const customMetric = name === 'custom' ? customMetrics.find(item => item.id === metric.name) : null;
    const formatter = customMetric ? (0, _create_formatter_for_metric.createFormatterForMetric)(customMetric) : (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
      type: metricName
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      key: metric.name
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      className: "eui-textTruncate eui-displayBlock",
      "data-test-subj": "conditionalTooltipContent-metric"
    }, customMetric ? (0, _get_custom_metric_label.getCustomMetricLabel)(customMetric) : name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "conditionalTooltipContent-value"
    }, metric.value && formatter(metric.value) || '-'));
  }));
});
exports.ConditionalToolTip = ConditionalToolTip;