"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createResultsUrl = exports.FlyoutHome = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/ml-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _subscription_splash_content = require("../../../../../../components/subscription_splash_content");
var _infra_ml_capabilities = require("../../../../../../containers/ml/infra_ml_capabilities");
var _log_analysis_setup = require("../../../../../../components/logging/log_analysis_setup");
var _module = require("../../../../../../containers/ml/modules/metrics_hosts/module");
var _module2 = require("../../../../../../containers/ml/modules/metrics_k8s/module");
var _loading_page = require("../../../../../../components/loading_page");
var _anomalies_table = require("./anomalies_table/anomalies_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutHome = props => {
  const [tab, setTab] = (0, _react.useState)('jobs');
  const {
    goToSetup,
    closeFlyout
  } = props;
  const {
    fetchJobStatus: fetchHostJobStatus,
    setupStatus: hostSetupStatus,
    jobSummaries: hostJobSummaries
  } = (0, _module.useMetricHostsModuleContext)();
  const {
    fetchJobStatus: fetchK8sJobStatus,
    setupStatus: k8sSetupStatus,
    jobSummaries: k8sJobSummaries
  } = (0, _module2.useMetricK8sModuleContext)();
  const {
    hasInfraMLCapabilities,
    hasInfraMLReadCapabilities,
    hasInfraMLSetupCapabilities
  } = (0, _infra_ml_capabilities.useInfraMLCapabilitiesContext)();
  const createHosts = (0, _react.useCallback)(() => {
    goToSetup('hosts');
  }, [goToSetup]);
  const createK8s = (0, _react.useCallback)(() => {
    goToSetup('kubernetes');
  }, [goToSetup]);
  const jobIds = [...(k8sJobSummaries || []).map(k => k.id), ...(hostJobSummaries || []).map(h => h.id)];
  (0, _react.useEffect)(() => {
    if (hasInfraMLReadCapabilities) {
      fetchHostJobStatus();
      fetchK8sJobStatus();
    }
  }, [fetchK8sJobStatus, fetchHostJobStatus, hasInfraMLReadCapabilities]);
  const hasJobs = hostJobSummaries.length > 0 || k8sJobSummaries.length > 0;
  const manageJobsLinkProps = (0, _public2.useLinkProps)({
    app: 'ml',
    pathname: '/jobs'
  });
  if (!hasInfraMLCapabilities) {
    return /*#__PURE__*/_react.default.createElement(_subscription_splash_content.SubscriptionSplashPrompt, null);
  } else if (!hasInfraMLReadCapabilities) {
    return /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingResultsPrivilegesPrompt, null);
  } else if (hostSetupStatus.type === 'initializing' || k8sSetupStatus.type === 'initializing') {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPrompt, {
      message: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.jobStatusLoadingMessage', {
        defaultMessage: 'Checking status of metrics jobs...'
      })
    });
  } else if (!hasInfraMLSetupCapabilities) {
    return /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingSetupPrivilegesPrompt, null);
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Machine Learning anomaly detection",
      id: "xpack.infra.ml.anomalyFlyout.flyoutHeader"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: tab === 'jobs',
      onClick: () => setTab('jobs')
    }, "Jobs"), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: tab === 'anomalies',
      onClick: () => setTab('anomalies'),
      "data-test-subj": "anomalyFlyoutAnomaliesTab"
    }, "Anomalies")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      banner: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tab === 'jobs' && hasJobs && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(JobsEnabledCallout, {
        hasHostJobs: hostJobSummaries.length > 0,
        hasK8sJobs: k8sJobSummaries.length > 0,
        jobIds: jobIds
      })), /*#__PURE__*/_react.default.createElement(_public.MLJobsAwaitingNodeWarning, {
        jobIds: jobIds
      }))
    }, tab === 'jobs' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasJobs && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 's'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      "data-test-subj": "infraFlyoutHomeManageJobsInMlButton"
    }, manageJobsLinkProps, {
      style: {
        marginRight: 5
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Manage jobs in ML",
      id: "xpack.infra.ml.anomalyFlyout.manageJobs"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Create ML Jobs"), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Anomaly detection is powered by machine learning. Machine learning jobs are available for the following resource types. Enable these jobs to begin detecting anomalies in your infrastructure metrics.",
      id: "xpack.infra.ml.anomalyFlyout.createJobs"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(CreateJobTab, {
      hasHostJobs: hostJobSummaries.length > 0,
      hasK8sJobs: k8sJobSummaries.length > 0,
      hasSetupCapabilities: props.hasSetupCapabilities,
      createHosts: createHosts,
      createK8s: createK8s
    })), tab === 'anomalies' && /*#__PURE__*/_react.default.createElement(_anomalies_table.AnomaliesTable, {
      closeFlyout: closeFlyout
    })));
  }
};
exports.FlyoutHome = FlyoutHome;
const JobsEnabledCallout = props => {
  let target = '';
  if (props.hasHostJobs && props.hasK8sJobs) {
    target = `${_i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.create.hostTitle', {
      defaultMessage: 'Hosts'
    })} and ${_i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.create.k8sSuccessTitle', {
      defaultMessage: 'Kubernetes'
    })}`;
  } else if (props.hasHostJobs) {
    target = _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.create.hostSuccessTitle', {
      defaultMessage: 'Hosts'
    });
  } else if (props.hasK8sJobs) {
    target = _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.create.k8sSuccessTitle', {
      defaultMessage: 'Kubernetes'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "success",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Anomaly detection enabled for {target}",
      id: "xpack.infra.ml.anomalyFlyout.enabledCallout",
      values: {
        target
      }
    }),
    iconType: "check"
  }));
};
const CreateJobTab = props => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    isDisabled: !props.hasSetupCapabilities,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'storage',
      size: "xl"
    })
    // title="Hosts"
    ,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Hosts",
      id: "xpack.infra.ml.anomalyFlyout.create.hostTitle"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Detect anomalies for memory usage and network traffic on hosts.",
      id: "xpack.infra.ml.anomalyFlyout.create.hostDescription"
    }),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, props.hasHostJobs && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraCreateJobTabRecreateJobsButton",
      onClick: props.createHosts
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Recreate jobs",
      id: "xpack.infra.ml.anomalyFlyout.create.recreateButton"
    })), !props.hasHostJobs && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraCreateJobTabEnableButton",
      onClick: props.createHosts
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Enable",
      id: "xpack.infra.ml.anomalyFlyout.create.createButton"
    })))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    isDisabled: !props.hasSetupCapabilities,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'logoKubernetes',
      size: "xl"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Kubernetes Pods",
      id: "xpack.infra.ml.anomalyFlyout.create.k8sTitle"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Detect anomalies for memory usage and network traffic on Kubernetes Pods.",
      id: "xpack.infra.ml.anomalyFlyout.create.k8sDescription"
    }),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, props.hasK8sJobs && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraCreateJobTabRecreateJobsButton",
      onClick: props.createK8s
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Recreate jobs",
      id: "xpack.infra.ml.anomalyFlyout.create.recreateButton"
    })), !props.hasK8sJobs && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraCreateJobTabEnableButton",
      onClick: props.createK8s
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Enable",
      id: "xpack.infra.ml.anomalyFlyout.create.createButton"
    })))
  }))));
};
const createResultsUrl = (jobIds, mode = 'absolute') => {
  const idString = jobIds.map(j => `'${j}'`).join(',');
  let path = '';
  const from = (0, _moment.default)().subtract(4, 'weeks').toISOString();
  const to = (0, _moment.default)().toISOString();
  path += `(ml:(jobIds:!(${idString}))`;
  path += `,refreshInterval:(display:Off,pause:!f,value:0),time:(from:'${from}'`;
  path += `,to:'${to}'`;
  if (mode === 'invalid') {
    path += `,mode:invalid`;
  }
  path += "))&_a=(query:(query_string:(analyze_wildcard:!t,query:'*')))";
  return path;
};
exports.createResultsUrl = createResultsUrl;