"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _metrics_source = require("../../../../../../containers/metrics_source");
var _flyout_home = require("./flyout_home");
var _job_setup_screen = require("./job_setup_screen");
var _infra_ml_capabilities = require("../../../../../../containers/ml/infra_ml_capabilities");
var _module = require("../../../../../../containers/ml/modules/metrics_hosts/module");
var _module2 = require("../../../../../../containers/ml/modules/metrics_k8s/module");
var _use_kibana_space = require("../../../../../../hooks/use_kibana_space");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalyDetectionFlyout = () => {
  var _source$configuration, _source$configuration2;
  const {
    hasInfraMLSetupCapabilities
  } = (0, _infra_ml_capabilities.useInfraMLCapabilities)();
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [screenName, setScreenName] = (0, _react.useState)('home');
  const [screenParams, setScreenParams] = (0, _react.useState)(null);
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const {
    space
  } = (0, _use_kibana_space.useActiveKibanaSpace)();
  const openFlyout = (0, _react.useCallback)(() => {
    setScreenName('home');
    setShowFlyout(true);
  }, []);
  const openJobSetup = (0, _react.useCallback)(jobType => {
    setScreenName('setup');
    setScreenParams({
      jobType
    });
  }, [setScreenName]);
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
  }, []);
  if ((source === null || source === void 0 ? void 0 : source.configuration.metricAlias) == null || space == null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "text",
    iconSide: 'left',
    iconType: 'inspect',
    onClick: openFlyout,
    "data-test-subj": "openAnomalyFlyoutButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.anomalyDetectionButton",
    defaultMessage: "Anomaly detection"
  })), showFlyout && /*#__PURE__*/_react.default.createElement(_module.MetricHostsModuleProvider, {
    indexPattern: (_source$configuration = source === null || source === void 0 ? void 0 : source.configuration.metricAlias) !== null && _source$configuration !== void 0 ? _source$configuration : '',
    sourceId: 'default',
    spaceId: space.id
  }, /*#__PURE__*/_react.default.createElement(_module2.MetricK8sModuleProvider, {
    indexPattern: (_source$configuration2 = source === null || source === void 0 ? void 0 : source.configuration.metricAlias) !== null && _source$configuration2 !== void 0 ? _source$configuration2 : '',
    sourceId: 'default',
    spaceId: space.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    "data-test-subj": "loadMLFlyout"
  }, screenName === 'home' && /*#__PURE__*/_react.default.createElement(_flyout_home.FlyoutHome, {
    hasSetupCapabilities: hasInfraMLSetupCapabilities,
    goToSetup: openJobSetup,
    closeFlyout: closeFlyout
  }), screenName === 'setup' && /*#__PURE__*/_react.default.createElement(_job_setup_screen.JobSetupScreen, {
    goHome: openFlyout,
    closeFlyout: closeFlyout,
    jobType: screenParams.jobType
  })))));
};
exports.AnomalyDetectionFlyout = AnomalyDetectionFlyout;