"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfrastructurePage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _help_center_content = require("../../components/help_center_content");
var _use_readonly_badge = require("../../hooks/use_readonly_badge");
var _use_metrics_explorer_options = require("./metrics_explorer/hooks/use_metrics_explorer_options");
var _with_metrics_explorer_options_url_state = require("../../containers/metrics_explorer/with_metrics_explorer_options_url_state");
var _metrics_explorer = require("./metrics_explorer");
var _inventory_view = require("./inventory_view");
var _metric_detail = require("./metric_detail");
var _settings = require("./settings");
var _hosts_landing_page = require("./hosts/hosts_landing_page");
var _source_loading_page = require("../../components/source_loading_page");
var _use_waffle_options = require("./inventory_view/hooks/use_waffle_options");
var _use_waffle_time = require("./inventory_view/hooks/use_waffle_time");
var _use_waffle_filters = require("./inventory_view/hooks/use_waffle_filters");
var _metrics_alert_dropdown = require("../../alerting/common/components/metrics_alert_dropdown");
var _use_alert_prefill = require("../../alerting/use_alert_prefill");
var _infra_ml_capabilities = require("../../containers/ml/infra_ml_capabilities");
var _anomaly_detection_flyout = require("./inventory_view/components/ml/anomaly_detection/anomaly_detection_flyout");
var _header_action_menu_provider = require("../../utils/header_action_menu_provider");
var _metrics_source = require("../../containers/metrics_source");
var _ = require("../404");
var _react_query_provider = require("../../containers/react_query_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_DATA_LABEL = _i18n.i18n.translate('xpack.infra.metricsHeaderAddDataButtonLabel', {
  defaultMessage: 'Add data'
});
const InfrastructurePage = ({
  match
}) => {
  var _useKibana$services$a, _uiCapabilities$infra, _kibana$services, _kibana$services$appl;
  const uiCapabilities = (_useKibana$services$a = (0, _public.useKibana)().services.application) === null || _useKibana$services$a === void 0 ? void 0 : _useKibana$services$a.capabilities;
  const {
    setHeaderActionMenu,
    theme$
  } = (0, _react.useContext)(_header_action_menu_provider.HeaderActionMenuContext);
  const settingsTabTitle = _i18n.i18n.translate('xpack.infra.metrics.settingsTabTitle', {
    defaultMessage: 'Settings'
  });
  const kibana = (0, _public.useKibana)();
  const {
    source,
    createDerivedIndexPattern
  } = (0, _metrics_source.useSourceContext)();
  (0, _use_readonly_badge.useReadOnlyBadge)(!(uiCapabilities !== null && uiCapabilities !== void 0 && (_uiCapabilities$infra = uiCapabilities.infrastructure) !== null && _uiCapabilities$infra !== void 0 && _uiCapabilities$infra.save));
  const settingsLinkProps = (0, _public2.useLinkProps)({
    app: 'metrics',
    pathname: 'settings'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_use_alert_prefill.AlertPrefillProvider, null, /*#__PURE__*/_react.default.createElement(_use_waffle_options.WaffleOptionsProvider, null, /*#__PURE__*/_react.default.createElement(_use_waffle_time.WaffleTimeProvider, null, /*#__PURE__*/_react.default.createElement(_use_waffle_filters.WaffleFiltersProvider, null, /*#__PURE__*/_react.default.createElement(_react_query_provider.ReactQueryProvider, null, /*#__PURE__*/_react.default.createElement(_infra_ml_capabilities.InfraMLCapabilitiesProvider, null, /*#__PURE__*/_react.default.createElement(_help_center_content.HelpCenterContent, {
    feedbackLink: "https://discuss.elastic.co/c/metrics",
    appName: _i18n.i18n.translate('xpack.infra.header.infrastructureHelpAppName', {
      defaultMessage: 'Metrics'
    })
  }), setHeaderActionMenu && theme$ && /*#__PURE__*/_react.default.createElement(_public2.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({
    color: 'text'
  }, settingsLinkProps), settingsTabTitle), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/inventory',
    component: _anomaly_detection_flyout.AnomalyDetectionFlyout
  }), /*#__PURE__*/_react.default.createElement(_metrics_alert_dropdown.MetricsAlertDropdown, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    href: (_kibana$services = kibana.services) === null || _kibana$services === void 0 ? void 0 : (_kibana$services$appl = _kibana$services.application) === null || _kibana$services$appl === void 0 ? void 0 : _kibana$services$appl.getUrlForApp('/integrations/browse'),
    color: "primary",
    iconType: "indexOpen"
  }, ADD_DATA_LABEL))), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/inventory',
    component: _inventory_view.SnapshotPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/explorer'
  }, /*#__PURE__*/_react.default.createElement(_use_metrics_explorer_options.MetricsExplorerOptionsContainer, null, /*#__PURE__*/_react.default.createElement(_with_metrics_explorer_options_url_state.WithMetricsExplorerOptionsUrlState, null), source !== null && source !== void 0 && source.configuration ? /*#__PURE__*/_react.default.createElement(PageContent, {
    configuration: source.configuration,
    createDerivedIndexPattern: createDerivedIndexPattern
  }) : /*#__PURE__*/_react.default.createElement(_source_loading_page.SourceLoadingPage, null))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/detail/:type/:node",
    component: _metric_detail.MetricDetail
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/hosts',
    component: _hosts_landing_page.HostsLandingPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/settings',
    component: _settings.MetricsSettingsPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => /*#__PURE__*/_react.default.createElement(_.NotFoundPage, {
      title: "Infrastructure"
    })
  })))))))));
};
exports.InfrastructurePage = InfrastructurePage;
const PageContent = props => {
  const {
    createDerivedIndexPattern,
    configuration
  } = props;
  return /*#__PURE__*/_react.default.createElement(_metrics_explorer.MetricsExplorerPage, (0, _extends2.default)({
    derivedIndexPattern: createDerivedIndexPattern(),
    source: configuration
  }, props));
};