"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/core/public");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
var _source_error_page = require("../../../components/source_error_page");
var _source_loading_page = require("../../../components/source_loading_page");
var _metrics_source = require("../../../containers/metrics_source");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _page_template = require("../page_template");
var _translations = require("../../../translations");
var _use_data_view = require("./hooks/use_data_view");
var _page_template2 = require("../../../page_template.styles");
var _hosts_container = require("./components/hosts_container");
var _beta_badge = require("../../../components/beta_badge");
var _empty_states = require("../../../components/empty_states");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOSTS_FEEDBACK_LINK = 'https://docs.google.com/forms/d/e/1FAIpQLScRHG8TIVb1Oq8ZhD4aks3P1TmgiM58TY123QpDCcBz83YC6w/viewform';
const KIBANA_VERSION_QUERY_PARAM = 'entry.548460210';
const getHostFeedbackURL = kibanaVersion => {
  const url = new URL(HOSTS_FEEDBACK_LINK);
  if (kibanaVersion) {
    url.searchParams.append(KIBANA_VERSION_QUERY_PARAM, kibanaVersion);
  }
  return url.href;
};
const HostsPage = () => {
  var _source$status;
  const {
    isLoading,
    loadSourceFailureMessage,
    loadSource,
    source
  } = (0, _metrics_source.useSourceContext)();
  const {
    services: {
      kibanaVersion
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'hosts'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'hosts',
    delay: 15000
  });
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.hostsTitle
  }]);
  const {
    metricIndicesExist,
    remoteClustersExist
  } = (_source$status = source === null || source === void 0 ? void 0 : source.status) !== null && _source$status !== void 0 ? _source$status : {};
  if (isLoading && !source) return /*#__PURE__*/_react.default.createElement(_source_loading_page.SourceLoadingPage, null);
  if (!remoteClustersExist) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.NoRemoteCluster, null);
  }
  if (!metricIndicesExist) {
    return /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
      hasData: metricIndicesExist,
      "data-test-subj": "noMetricsIndicesPrompt"
    });
  }
  if (loadSourceFailureMessage) return /*#__PURE__*/_react.default.createElement(_source_error_page.SourceErrorPage, {
    errorMessage: loadSourceFailureMessage || '',
    retry: loadSource
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement("div", {
    className: _public2.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
    hasData: metricIndicesExist,
    pageHeader: {
      alignItems: 'center',
      pageTitle: /*#__PURE__*/_react.default.createElement("div", {
        css: (0, _react2.css)`
                  display: flex;
                  align-items: center;
                  gap: 0.75rem;
                `
      }, /*#__PURE__*/_react.default.createElement("h1", null, _translations.hostsTitle), /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
        tooltipContent: _i18n.i18n.translate('xpack.infra.hostsViewPage.betaBadgeDescription', {
          defaultMessage: 'This feature is currently in beta. If you encounter any bugs or have feedback, we’d love to hear from you. Please open a support issue and/or share your feedback via the "Tell us what you think!" feedback button.'
        })
      })),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "infraHostsPageTellUsWhatYouThinkButton",
        href: getHostFeedbackURL(kibanaVersion),
        target: "_blank",
        color: "warning",
        iconType: "editorComment"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.hostsPage.tellUsWhatYouThinkLink",
        defaultMessage: "Tell us what you think!"
      }))]
    },
    pageSectionProps: {
      contentProps: {
        css: _page_template2.fullHeightContentStyles
      }
    }
  }, source && /*#__PURE__*/_react.default.createElement(_use_data_view.MetricsDataViewProvider, {
    metricAlias: source.configuration.metricAlias
  }, /*#__PURE__*/_react.default.createElement(_hosts_container.HostContainer, null)))));
};
exports.HostsPage = HostsPage;